/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.filter;

/**
 * Common interface for attribute filters.
 *
 */
public interface AttributeFilter {

    /**
     * Checks if an attribute should be included or excluded.
     * @param attributeName Name of the role or attribute.
     * @param domainObject The domain object where the attribute is.
     * @return true if the role or attribute passed through this filter.
     */
    public boolean isAttributeIncluded(String attributeName, Object domainObject);

}
