/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.transport;

import no.g9.os.OSRole;

/**
 * Interface used to handle the transfer of values to and from transport and domain objects.
 * 
 * Note that this may be a shallow transfer, and this should be noted in the implementing class.
 * 
 * @param <D>
 *            the generic type of domain object
 * @param <T>
 *            the generic type of transport object
 */
public interface DomainTransportTransfer<D, T> {
    /**
     * Transfer values from the transport to domain object.
     * 
     * @param transportObject
     *            the source object
     * @param domainObject
     *            the target object
     */
    public void transferToDomain(final T transportObject, final D domainObject);

    /**
     * Transfer values from the domain to transport object.
     * 
     * @param domainObject
     *            the source object
     * 
     * @param transportObject
     *            the target object
     */
    public void transferToTransport(final D domainObject, final T transportObject);
    
    /**
     * Gets the domain type.
     * 
     * @return the domain type
     */
    Class<D> getDomainType();

    /**
     * Gets the transport type.
     * 
     * @return the transport type
     */
    Class<T> getTransportType();


    /**
     * This will return the <code>OSRole</code> that can be used for a deep conversion of the object graph.
     * 
     * @return the OSRole
     */
    public OSRole<?> getOSRole();
    
    
    /**
     * @return The parent association role name if navigable to parent, else <code>null</code>
     */
    public String getParentAssociationRoleName();

}
