/*
 * Decompiled with CFR 0.152.
 */
package no.esito.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    private static final Calendar CALENDAR = Calendar.getInstance();
    private static String[] supportedYYYYFormats = DateUtil.load4YDateFormats();
    private static String[] supportedYYFormats = DateUtil.load2YDateFormats();
    private static String[] supportedMMMFormats = DateUtil.load3MDateFormats();

    private static String[] load4YDateFormats() {
        return new String[]{"dd.MM.yyyy", "dd/MM/yyyy", "dd-MM-yyyy", "dd.MM.yyyy HH", "dd/MM/yyyy HH", "dd-MM-yyyy HH", "dd.MM.yyyy HH:mm", "dd/MM/yyyy HH:mm", "dd-MM-yyyy HH:mm", "dd.MM.yyyy HH:mm:ss", "dd/MM/yyyy HH:mm:ss", "dd-MM-yyyy HH:mm:ss"};
    }

    private static String[] load2YDateFormats() {
        String[] temp = new String[]{"dd.MM.yy", "dd/MM/yy", "dd-MM-yy"};
        return temp;
    }

    private static String[] load3MDateFormats() {
        String[] temp = new String[]{"dd.MMM.yyyy", "dd/MMM/yyyy", "dd-MMM-yyyy"};
        return temp;
    }

    public static DateFormat getParseFormat(String inputDateStr, Locale locale) {
        if (!DateUtil.isValidDate(inputDateStr)) {
            return null;
        }
        String[] formats = DateUtil.getFormats(inputDateStr);
        for (int i = 0; i < formats.length; ++i) {
            try {
                SimpleDateFormat formatRef = new SimpleDateFormat(formats[i], locale);
                formatRef.setLenient(false);
                Date d = formatRef.parse(inputDateStr);
                if (!DateUtil.isInteger(inputDateStr)) {
                    if (!formatRef.format(d).equals(inputDateStr)) continue;
                    return formatRef;
                }
                return formatRef;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String[] getFormats(String inputDateStr) {
        if (DateUtil.isInteger(inputDateStr)) {
            switch (inputDateStr.length()) {
                case 8: {
                    return new String[]{"ddMMyyyy"};
                }
                case 10: {
                    return new String[]{"ddMMyyyyHH"};
                }
                case 12: {
                    return new String[]{"ddMMyyyyHHmm"};
                }
            }
            return new String[]{"ddMMyyyyHHmmss"};
        }
        if (inputDateStr.length() == 8) {
            return supportedYYFormats;
        }
        if (inputDateStr.length() == 11) {
            return supportedMMMFormats;
        }
        return supportedYYYYFormats;
    }

    public static boolean isInteger(String input) {
        for (int i = 0; i < input.length(); ++i) {
            if (Character.isDigit(input.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidDate(String value) {
        return value != null && value.length() >= 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date endOfDay(Date date) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTime(date);
            calendar.set(11, 23);
            calendar.set(14, 999);
            calendar.set(13, 59);
            calendar.set(12, 59);
            return calendar.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date startOfDay(Date date) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            return calendar.getTime();
        }
    }

    public static Date stringToDate(String str_date, String format) {
        Date date = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            date = formatter.parse(str_date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static String dateToString(Date date, String format) {
        String str_date = null;
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        str_date = formatter.format(date);
        return str_date;
    }
}

