/*
 * Decompiled with CFR 0.152.
 */
package no.g9.domain;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import no.g9.domain.LockFlag;
import no.g9.domain.PersistentClass;
import no.g9.exception.G9BaseException;
import no.g9.support.Registry;
import org.hibernate.LazyInitializationException;
import org.hibernate.collection.internal.PersistentSet;
import org.hibernate.proxy.HibernateProxy;

public class DomainUtil {
    private static final String PROP_IGNORE_LOCKFLAG = "DomainUtil.ignoreLockFlag";
    private static boolean ignoreLockFlag = false;

    private DomainUtil() {
    }

    public static <T, U extends T> Class<T> getDomainClass(U domainObject) {
        return domainObject instanceof HibernateProxy ? domainObject.getClass().getSuperclass() : domainObject.getClass();
    }

    public static <T, U extends T> Class<T> getDomainClass(Class<U> clazz) {
        Class<U> retClass = HibernateProxy.class.isAssignableFrom(clazz) ? clazz.getSuperclass() : clazz;
        return retClass;
    }

    public static <T, U extends T> Class<T> getDomainSuperClass(Class<U> clazz) {
        if (clazz.equals(Object.class)) {
            return null;
        }
        return clazz.getSuperclass();
    }

    private static Method[] getLockFlagPropertyMethods(Object object) {
        Method getMethod = null;
        Method setMethod = null;
        try {
            getMethod = object.getClass().getMethod("getLockFlag", new Class[0]);
            setMethod = object.getClass().getMethod("setLockFlag", Serializable.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException e) {
            throw new G9BaseException(e);
        }
        return new Method[]{getMethod, setMethod};
    }

    public static boolean hasLockFlag(Object domainObject) {
        if (ignoreLockFlag) {
            return false;
        }
        if (domainObject instanceof LockFlag) {
            return true;
        }
        Method[] methods = DomainUtil.getLockFlagPropertyMethods(domainObject);
        return methods[0] != null && methods[1] != null;
    }

    public static Serializable getLockFlag(Object domainObject) {
        if (ignoreLockFlag) {
            return null;
        }
        if (domainObject instanceof LockFlag) {
            return ((LockFlag)domainObject).getLockFlag();
        }
        Method[] methods = DomainUtil.getLockFlagPropertyMethods(domainObject);
        if (methods[0] == null || methods[1] == null) {
            return null;
        }
        try {
            return (Serializable)methods[0].invoke(domainObject, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new G9BaseException(e);
        }
        catch (IllegalAccessException e) {
            throw new G9BaseException(e);
        }
        catch (SecurityException e) {
            throw new G9BaseException(e);
        }
        catch (InvocationTargetException e) {
            throw new G9BaseException(e);
        }
    }

    public static void setLockFlag(Object domainObject, Serializable lockFlag) {
        if (ignoreLockFlag) {
            return;
        }
        if (domainObject instanceof LockFlag) {
            ((LockFlag)domainObject).setLockFlag(lockFlag);
            return;
        }
        Method[] methods = DomainUtil.getLockFlagPropertyMethods(domainObject);
        if (methods[0] == null || methods[1] == null) {
            return;
        }
        try {
            methods[1].invoke(domainObject, lockFlag);
        }
        catch (IllegalArgumentException e) {
            throw new G9BaseException(e);
        }
        catch (IllegalAccessException e) {
            throw new G9BaseException(e);
        }
        catch (SecurityException e) {
            throw new G9BaseException(e);
        }
        catch (InvocationTargetException e) {
            throw new G9BaseException(e);
        }
    }

    public static boolean equalsLockFlag(Serializable flag1, Serializable flag2) {
        if (flag1 == null || flag2 == null) {
            return false;
        }
        if (!flag1.getClass().equals(flag2.getClass())) {
            return false;
        }
        if (flag1.getClass().isArray()) {
            for (int ix = 0; ix < Array.getLength(flag1); ++ix) {
                Object elem2;
                Object elem1 = Array.get(flag1, ix);
                if (elem1.equals(elem2 = Array.get(flag2, ix))) continue;
                return false;
            }
            return true;
        }
        return flag1.equals(flag2);
    }

    public static boolean isLazy(Object o) {
        if (o instanceof Set) {
            return DomainUtil.isLazy((Set)o);
        }
        if (o == null) {
            return false;
        }
        try {
            o.hashCode();
        }
        catch (LazyInitializationException e) {
            return true;
        }
        return false;
    }

    public static boolean isLazy(Set<? extends Object> s) {
        if (s == null) {
            return false;
        }
        if (s instanceof PersistentSet) {
            PersistentSet pSet = (PersistentSet)s;
            return !pSet.wasInitialized();
        }
        try {
            Iterator<? extends Object> it = s.iterator();
            if (it.hasNext()) {
                Object o = it.next();
                o.hashCode();
            }
        }
        catch (LazyInitializationException e) {
            return true;
        }
        return false;
    }

    public static <T, U extends T> U strip(U domainObject, Class<T> domainClass, Set<String> ignore) {
        if (domainObject != null) {
            Object[] extractedMethods = DomainUtil.extractMethods(domainClass, ignore);
            Method[] getMethods = (Method[])extractedMethods[0];
            Map setMethods = (Map)extractedMethods[1];
            for (int i = 0; i < getMethods.length; ++i) {
                Method method = getMethods[i];
                String methodName = method.getName();
                try {
                    Object fieldValue = DomainUtil.getProperty(domainObject, method);
                    if (!DomainUtil.shouldStrip(fieldValue)) continue;
                    Method setMethod = (Method)setMethods.get(DomainUtil.asPropertyName(methodName));
                    Object[] args = new Object[]{null};
                    setMethod.invoke(domainObject, args);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new G9BaseException(e);
                }
                catch (IllegalAccessException e) {
                    throw new G9BaseException(e);
                }
                catch (SecurityException e) {
                    throw new G9BaseException(e);
                }
                catch (InvocationTargetException e) {
                    throw new G9BaseException(e);
                }
            }
        }
        return domainObject;
    }

    public static void stripRecursive(Object domainObject, Object parent) {
        Set<String> dummyIgnore = Collections.emptySet();
        Class domainClass = DomainUtil.getDomainClass(domainObject);
        Object[] extractedMethods = DomainUtil.extractMethods(domainClass, dummyIgnore);
        Method[] getMethods = (Method[])extractedMethods[0];
        Map setMethods = (Map)extractedMethods[1];
        for (int i = 0; i < getMethods.length; ++i) {
            Method method = getMethods[i];
            Method setMethod = null;
            try {
                Object fieldValue = DomainUtil.getProperty(domainObject, method);
                if (!DomainUtil.shouldStrip(fieldValue)) continue;
                setMethod = (Method)setMethods.get(DomainUtil.asPropertyName(method.getName()));
                Object related2 = fieldValue;
                if (related2 instanceof Collection) {
                    Collection s = (Collection)related2;
                    for (Object related2 : s) {
                        DomainUtil.stripRecursive(related2, domainObject);
                    }
                    continue;
                }
                if (related2 == null || related2 == parent) continue;
                related2.hashCode();
                DomainUtil.stripRecursive(related2, domainObject);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new G9BaseException(e);
            }
            catch (IllegalAccessException e) {
                throw new G9BaseException(e);
            }
            catch (SecurityException e) {
                throw new G9BaseException(e);
            }
            catch (InvocationTargetException e) {
                DomainUtil.setProperty(domainObject, setMethod, null);
                continue;
            }
            catch (LazyInitializationException e) {
                DomainUtil.setProperty(domainObject, setMethod, null);
            }
        }
    }

    private static <T> Object[] extractMethods(Class<T> domainClass, Set<String> ignore) {
        AccessibleObject[] methods = domainClass.getMethods();
        AccessibleObject.setAccessible(methods, true);
        ArrayList<AccessibleObject> tmpGetMethods = new ArrayList<AccessibleObject>();
        HashMap<String, AccessibleObject> tmpSetMethods = new HashMap<String, AccessibleObject>();
        for (int i = 0; i < methods.length; ++i) {
            AccessibleObject method = methods[i];
            String methodName = ((Method)method).getName();
            if (DomainUtil.ignore(methodName, ignore)) continue;
            if (DomainUtil.isSetMethod(methodName)) {
                tmpSetMethods.put(DomainUtil.asPropertyName(methodName), method);
                continue;
            }
            if (!DomainUtil.isGetMethod(methodName)) continue;
            tmpGetMethods.add(method);
        }
        Object[] retVal = new Object[]{tmpGetMethods.toArray(new Method[0]), tmpSetMethods};
        return retVal;
    }

    private static boolean ignore(String methodName, Set<String> ignore) {
        return methodName.length() > 3 && ignore.contains(DomainUtil.asPropertyName(methodName));
    }

    private static boolean isGetMethod(String methodName) {
        return methodName.startsWith("get");
    }

    private static boolean isSetMethod(String methodName) {
        return methodName.startsWith("set");
    }

    private static boolean shouldStrip(Object fieldValue) {
        return fieldValue != null && (DomainUtil.isPersistentClass(fieldValue) || DomainUtil.isCollection(fieldValue));
    }

    private static boolean isCollection(Object object) {
        return object instanceof Collection;
    }

    private static Object getProperty(Object domainObject, Method getMethod) throws SecurityException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{};
        try {
            return getMethod.invoke(domainObject, args);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static void setProperty(Object domainObject, Method setMethod, Object value) {
        if (domainObject != null && setMethod != null) {
            try {
                Object[] args = new Object[]{value};
                setMethod.invoke(domainObject, args);
            }
            catch (InvocationTargetException ie) {
                throw new G9BaseException(ie);
            }
            catch (IllegalArgumentException ie) {
                throw new G9BaseException(ie);
            }
            catch (IllegalAccessException ie) {
                throw new G9BaseException(ie);
            }
            catch (SecurityException ie) {
                throw new G9BaseException(ie);
            }
        }
    }

    private static String asPropertyName(String methodName) {
        if (methodName.length() <= 3) {
            return null;
        }
        String propName = String.valueOf(Character.toLowerCase(methodName.charAt(3)));
        if (methodName.length() > 4) {
            propName = propName + methodName.substring(4);
        }
        return propName;
    }

    private static boolean isPersistentClass(Object object) {
        return object instanceof PersistentClass;
    }

    static {
        String prop = Registry.getRegistry().getG9Property(PROP_IGNORE_LOCKFLAG);
        if ("TRUE".equalsIgnoreCase(prop)) {
            ignoreLockFlag = true;
        }
    }
}

