/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message;

import java.util.LinkedList;
import java.util.List;
import no.g9.message.MessageConfigurator;
import no.g9.message.MessageInteractor;
import no.g9.message.MessageLogger;
import no.g9.message.PropertyFileConfigurator;
import no.g9.message.SimpleLogger;
import no.g9.message.SimpleMsgInteractor;
import no.g9.message.administration.IMessageAdmin;

public class MessageAdmin
implements IMessageAdmin {
    private List<MessageConfigurator> providers = new LinkedList<MessageConfigurator>();
    private List<MessageLogger> loggers = new LinkedList<MessageLogger>();
    private static String defaultLoggerName = "no.g9";
    private static String messageFileName = "message/g9.runtime.messages";
    private MessageInteractor msgInteractor;

    public MessageAdmin() {
        this.providers.add(new PropertyFileConfigurator(messageFileName));
        this.loggers.add(new SimpleLogger(defaultLoggerName));
        this.msgInteractor = new SimpleMsgInteractor();
    }

    @Override
    public void addLogger(MessageLogger logger) {
        this.loggers.add(logger);
    }

    @Override
    public void addProvider(MessageConfigurator provider) {
        this.providers.add(provider);
    }

    @Override
    public void clearLoggers() {
        this.loggers.clear();
    }

    @Override
    public void clearProviders() {
        this.providers.clear();
    }

    @Override
    public MessageInteractor getInteractor() {
        return this.msgInteractor;
    }

    @Override
    public List<MessageLogger> getLoggers() {
        return this.loggers;
    }

    @Override
    public List<MessageConfigurator> getProviders() {
        return this.providers;
    }

    @Override
    public void setInteractor(MessageInteractor msgInteractor) {
        this.msgInteractor = msgInteractor;
    }

    @Override
    public void setLoggers(List<MessageLogger> loggers) {
        if (loggers == null) {
            throw new NullPointerException("loggers can not be null");
        }
        this.loggers = loggers;
    }

    @Override
    public void setProviders(List<MessageConfigurator> providers) {
        if (providers == null) {
            throw new NullPointerException("providers can not be null");
        }
        this.providers = providers;
    }

    public static String getDefaultLoggerName() {
        return defaultLoggerName;
    }

    public static void setDefaultLoggerName(String defaultLoggerName) {
        MessageAdmin.defaultLoggerName = defaultLoggerName;
    }
}

