/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message;

import no.g9.message.DispatcherContext;
import no.g9.message.DispatcherContextProvider;
import no.g9.message.Message;
import no.g9.message.MessageDispatcherSetup;
import no.g9.message.MessageInteractor;
import no.g9.message.MessageLogDispatcher;
import no.g9.message.MessageReply;
import no.g9.message.MessageSystem;
import org.springframework.beans.factory.annotation.Autowired;

public class MessageDispatcherImpl
implements MessageDispatcherSetup {
    private MessageLogDispatcher messageLogDispatcher;
    private MessageInteractor messageInteractor;
    private DispatcherContext dispatcherContext;
    private DispatcherContextProvider dispatcherContextProvider;

    @Autowired(required=false)
    public void setMessageLogDispatcher(MessageLogDispatcher messageLogDispatcher) {
        this.messageLogDispatcher = messageLogDispatcher;
    }

    @Autowired(required=false)
    public void setDispatcherContextProvider(DispatcherContextProvider dispatcherContextProvider) {
        this.dispatcherContextProvider = dispatcherContextProvider;
    }

    public void setMessageInteractor(MessageInteractor messageInteractor) {
        this.messageInteractor = messageInteractor;
    }

    @Override
    public void setDispatcherContext(DispatcherContext dispatcherContext) {
        this.dispatcherContext = dispatcherContext;
    }

    @Override
    public MessageReply dispatch(String id, Object ... args) {
        Message message = MessageSystem.getMessageFactory().getMessage(id, args);
        return this.dispatch(message);
    }

    @Override
    public MessageReply dispatch(Message message) {
        DispatcherContext currentDispatcherContext = this.getDispatcherContext();
        if (this.messageLogDispatcher != null) {
            this.messageLogDispatcher.log(message, currentDispatcherContext);
        }
        MessageReply reply = null;
        if (this.messageInteractor != null && MessageSystem.NO_INTERACTION != currentDispatcherContext) {
            reply = this.messageInteractor.interact(message, currentDispatcherContext);
        }
        return reply;
    }

    @Override
    public MessageReply dispatch(String id, Throwable exception, Object ... args) {
        Message message = MessageSystem.getMessageFactory().getMessage(id, args);
        if (exception != null) {
            message.setException(exception);
        }
        return this.dispatch(message);
    }

    private DispatcherContext getDispatcherContext() {
        if (this.dispatcherContext == null) {
            if (this.dispatcherContextProvider != null) {
                return this.dispatcherContextProvider.getDispatcherContext();
            }
            return MessageSystem.NO_INTERACTION;
        }
        return this.dispatcherContext;
    }
}

