/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import no.g9.message.FixedTextPart;
import no.g9.message.ITextPart;
import no.g9.message.NewLinePart;
import no.g9.message.NumVarPart;
import no.g9.message.SpecialVarPart;

public final class StdParser {
    static String cStart = "<";
    static String cSep = ";";
    static String cEnd = ">";
    static Pattern variableRe = Pattern.compile(cStart + "[^" + cEnd + "]+" + cEnd);
    static String lfRe = "\\\\n";

    private StdParser() {
    }

    public static void parse(String raw, List<ITextPart> result) {
        if (raw == null) {
            return;
        }
        int lastEnd = 0;
        Matcher m = variableRe.matcher(raw);
        while (m.find()) {
            int starts = m.start();
            int ends = m.end();
            if (starts > lastEnd) {
                StdParser.parseFixed(raw.substring(lastEnd, starts), result);
            }
            lastEnd = ends;
            result.add(StdParser.parseVar(raw.substring(starts + 1, ends - 1)));
        }
        if (lastEnd < raw.length()) {
            StdParser.parseFixed(raw.substring(lastEnd), result);
        }
        if (result.size() == 0) {
            result.add(new FixedTextPart(""));
        }
    }

    private static ITextPart parseVar(String varTxt) {
        String[] parts = new String[]{"", "", "", ""};
        String[] parts1 = varTxt.split(cSep, parts.length);
        for (int i = 0; i < parts1.length; ++i) {
            parts[i] = parts1[i];
        }
        if (parts[0].matches("[0-9]+")) {
            return new NumVarPart(Integer.parseInt(parts[0]), parts[1], parts[2], parts[3]);
        }
        return new SpecialVarPart(varTxt);
    }

    private static void parseFixed(String fix, List<ITextPart> result) {
        String[] parts = fix.split(lfRe, -1);
        for (int i = 0; i < parts.length; ++i) {
            if (i >= 1) {
                result.add(new NewLinePart());
            }
            if ("".equals(parts[i])) continue;
            result.add(new FixedTextPart(parts[i]));
        }
    }
}

