/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.convert;

import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.support.convert.ConvertContext;

public class ConvertException
extends Exception {
    private Message errMsg;
    private ConvertContext convertContext;
    private Object provokingValue;

    public ConvertException(ConvertContext convertContext, Object provokingValue, Throwable cause) {
        super(cause);
        this.convertContext = convertContext;
        this.provokingValue = provokingValue;
        this.setErrMsg(MessageSystem.getMessageFactory().getMessage("-1000", cause.getLocalizedMessage()));
        this.getErrMsg().setException(cause);
    }

    public ConvertException(ConvertContext convertContext, Object provokingValue, String message, Throwable cause) {
        super(message, cause);
        this.convertContext = convertContext;
        this.provokingValue = provokingValue;
        this.setErrMsg(MessageSystem.getMessageFactory().getMessage("-1000", message));
        this.getErrMsg().setException(cause);
    }

    public ConvertException(ConvertContext convertContext, Object provokingValue, String message) {
        super(message);
        this.convertContext = convertContext;
        this.provokingValue = provokingValue;
        this.setErrMsg(MessageSystem.getMessageFactory().getMessage("-1000", message));
    }

    public ConvertException(ConvertContext convertContext, Object provokingValue, Message errMsg) {
        super(errMsg != null ? errMsg.getMessageText() : null);
        this.convertContext = convertContext;
        this.provokingValue = provokingValue;
        this.setErrMsg(errMsg);
    }

    public ConvertException(ConvertContext convertContext, Object provokingValue, Throwable cause, Message errMsg) {
        super(errMsg != null ? errMsg.getMessageText() : null, cause);
        this.convertContext = convertContext;
        this.provokingValue = provokingValue;
        this.setErrMsg(errMsg);
        this.getErrMsg().setException(cause);
    }

    public final void setErrMsg(Message errMsg) {
        this.errMsg = errMsg;
    }

    public final Message getErrMsg() {
        return this.errMsg;
    }

    public ConvertContext getConvertContext() {
        return this.convertContext;
    }

    public Object getProvokingValue() {
        return this.provokingValue;
    }
}

