/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.convert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import no.esito.log.Logger;
import no.esito.util.DateUtil;
import no.g9.exception.SimpleDateConverterException;
import no.g9.support.FormatHelper;

public class SimpleDateConverter {
    private String dataType;
    private String displayRule;
    private String defaultStyle;
    private Locale locale;
    private static final Logger log = Logger.getLogger(SimpleDateConverter.class);

    public SimpleDateConverter(String dataType, String displayRule, Locale locale) {
        this.dataType = dataType;
        this.displayRule = displayRule;
        this.defaultStyle = "default";
        this.locale = locale;
    }

    public SimpleDateConverter(String dataType, String displayRule) {
        this.dataType = dataType;
        this.displayRule = displayRule;
        this.defaultStyle = "default";
        this.locale = Locale.getDefault();
    }

    public Object getAsObject(String value) {
        if (log.isTraceEnabled()) {
            log.trace("Parsing value \"" + value + "\", display rule \"" + this.getDisplayRule() + "\", data type \"" + this.getDataType() + "\"");
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        Locale locale = this.getLocale();
        DateFormat parser = null;
        try {
            if (this.getDataType().equals("date") || this.getDataType().equals("timestamp")) {
                parser = this.parseLocaleFormat(value);
                if (parser == null && (parser = DateUtil.getParseFormat(value, locale)) == null) {
                    parser = this.getDateFormatFromDisplayRule(locale);
                }
                if (parser == null) {
                    throw new ParseException("", 0);
                }
            } else {
                parser = this.getDateFormatFromDisplayRule(locale);
            }
            if (null != this.getTimeZone()) {
                parser.setTimeZone(this.getTimeZone());
            }
            return parser.parse(value);
        }
        catch (Exception e) {
            throw new SimpleDateConverterException(e);
        }
    }

    private Locale getLocale() {
        return this.locale;
    }

    private TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    private DateFormat parseLocaleFormat(String value) {
        DateFormat localeDateFormat = DateFormat.getDateInstance(2, this.getLocale());
        localeDateFormat.setLenient(false);
        try {
            localeDateFormat.parse(value);
        }
        catch (ParseException e) {
            localeDateFormat = null;
        }
        return localeDateFormat;
    }

    public String getAsString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return this.dateToString(value, this.getLocale());
    }

    String dateToString(Object value, Locale locale) {
        DateFormat formatter = this.getDateFormatFromDisplayRule(locale);
        if (null != this.getTimeZone()) {
            formatter.setTimeZone(this.getTimeZone());
        }
        return formatter.format(value);
    }

    DateFormat getDateFormatFromDisplayRule(Locale locale) {
        if (this.getDisplayRule() == null && this.getDataType() == null) {
            return null;
        }
        DateFormat df = null;
        if (this.getDisplayRule() != null && !this.getDisplayRule().equals("")) {
            String format = FormatHelper.getDatetimeFormat(this.getDisplayRule());
            if (format == null) {
                throw new IllegalArgumentException("Unsupported display rule \"" + this.getDisplayRule() + "\"");
            }
            if (log.isTraceEnabled()) {
                log.trace("Using format \"" + format + "\" for display rule \"" + this.getDisplayRule() + "\"");
            }
            df = new SimpleDateFormat(format, locale);
        } else if (this.getDataType().equals("both") || this.getDataType().equals("timestamp")) {
            df = DateFormat.getDateTimeInstance(this.getStyle(this.getDefaultStyle()), this.getStyle(this.getDefaultStyle()), locale);
        } else if (this.getDataType().equals("date")) {
            df = DateFormat.getDateInstance(this.getStyle(this.getDefaultStyle()), locale);
        } else if (this.getDataType().equals("time")) {
            df = DateFormat.getTimeInstance(this.getStyle(this.getDefaultStyle()), locale);
        } else {
            throw new IllegalArgumentException("Invalid datatype: " + this.getDataType());
        }
        df.setLenient(false);
        return df;
    }

    private int getStyle(String name) {
        if ("default".equals(name)) {
            return 2;
        }
        if ("short".equals(name)) {
            return 3;
        }
        if ("medium".equals(name)) {
            return 2;
        }
        if ("long".equals(name)) {
            return 1;
        }
        if ("full".equals(name)) {
            return 0;
        }
        throw new SimpleDateConverterException("Invalid style '" + name + '\'');
    }

    public void setDisplayRule(String displayRule) {
        this.displayRule = displayRule;
    }

    public String getDisplayRule() {
        return this.displayRule;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(String defaultStyle) {
        this.defaultStyle = defaultStyle;
    }
}

