/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.filter;

import java.util.HashSet;
import java.util.Set;
import no.g9.support.filter.AttributeFilter;
import no.g9.support.filter.RoleFilter;

public class SimpleFilter
implements AttributeFilter,
RoleFilter {
    protected HashSet<String> excludedRoleNames = new HashSet();
    protected HashSet<String> excludedAttributeNames = new HashSet();

    @Override
    public boolean isRoleIncluded(String roleName, Object domainObject) {
        return !this.excludedRoleNames.contains(roleName);
    }

    @Override
    public boolean isAttributeIncluded(String attributeName, Object domainObject) {
        return !this.excludedAttributeNames.contains(attributeName);
    }

    public SimpleFilter addExcludedRoleName(String roleName) {
        this.excludedRoleNames.add(roleName);
        return this;
    }

    public SimpleFilter addExcludedRoleNames(Set<String> roleName) {
        this.excludedRoleNames.addAll(roleName);
        return this;
    }

    public SimpleFilter addExcludedRoleNames(String[] roleNames) {
        for (String s : roleNames) {
            this.addExcludedRoleName(s);
        }
        return this;
    }

    public SimpleFilter addExcludedAttributeName(String attributeName) {
        this.excludedAttributeNames.add(attributeName);
        return this;
    }

    public SimpleFilter addExcludedAttributeNames(Set<String> attributeNames) {
        this.excludedAttributeNames.addAll(attributeNames);
        return this;
    }

    public void addExcludedAttributeNames(String[] attributeNames) {
        for (String s : attributeNames) {
            this.addExcludedAttributeName(s);
        }
    }
}

