/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.transport;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import no.esito.log.Logger;
import no.g9.os.AssociationRoleConstant;
import no.g9.os.OSRole;
import no.g9.os.RelationCardinality;
import no.g9.os.RoleConstant;
import no.g9.support.transport.DomainTransportConverterRegistry;
import no.g9.support.transport.DomainTransportTransfer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DomainTransportConversionService
implements ConversionService {
    private DomainTransportConverterRegistry domainTransportConverterRegistry;
    private ConversionService domainTransportTypeConversionService;
    private static final Logger logger = Logger.getLogger(DomainTransportConversionService.class);

    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("The targetType to convert to cannot be null");
        }
        return this.canConvert(sourceType != null ? TypeDescriptor.valueOf(sourceType) : null, TypeDescriptor.valueOf(targetType));
    }

    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.domainTransportTypeConversionService.canConvert(sourceType, targetType) || this.domainTransportConverterRegistry.canConvert(sourceType, targetType);
    }

    public <T> T convert(Object source, Class<T> targetType) {
        Assert.notNull(targetType, (String)"The targetType to convert to cannot be null");
        return (T)this.convert(source, TypeDescriptor.forObject((Object)source), TypeDescriptor.valueOf(targetType));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        if (source instanceof Collection) {
            return this.convert((Collection)source, targetType);
        }
        if (this.domainTransportTypeConversionService.canConvert(sourceType, targetType)) {
            return this.domainTransportTypeConversionService.convert(source, sourceType, targetType);
        }
        DomainTransportTransfer converter = this.getDomainTransportConverterRegistry().getConverter(sourceType, targetType);
        Assert.notNull(converter, (String)("No converter registered for source '" + source.getClass() + "' and target '" + targetType + "'"));
        OSRole<?> rootRole = converter.getOSRole();
        ConversionDirection conversionDirection = converter.getTransportType() == targetType.getType() ? ConversionDirection.DOMAIN2TRANSPORT : ConversionDirection.TRANSPORT2DOMAIN;
        Assert.notNull(rootRole, (String)"rootRole must not be null");
        if (!rootRole.isRoot()) {
            throw new IllegalArgumentException("Only conversion of root roles is supported");
        }
        IdentityHashMap<Object, Object> processedObjects = new IdentityHashMap<Object, Object>();
        BeanWrapperImpl convertTo = new BeanWrapperImpl();
        BeanWrapperImpl convertFrom = new BeanWrapperImpl(source);
        this.convertNode(rootRole, convertFrom, convertTo, conversionDirection, processedObjects, "");
        return convertTo.getRootInstance();
    }

    private <S, T> Collection<T> convert(Collection<S> sourceCollection, TypeDescriptor itemTargetType) {
        if (sourceCollection == null) {
            return null;
        }
        Collection targetCollection = CollectionFactory.createApproximateCollection(sourceCollection, (int)16);
        if (sourceCollection.isEmpty()) {
            return targetCollection;
        }
        S firstElement = sourceCollection.iterator().next();
        Class<?> collectionType = sourceCollection.getClass();
        TypeDescriptor itemSourceType = TypeDescriptor.forObject(firstElement);
        TypeDescriptor sourceType = TypeDescriptor.collection(collectionType, (TypeDescriptor)itemSourceType);
        TypeDescriptor targetType = TypeDescriptor.collection(collectionType, (TypeDescriptor)itemTargetType);
        if (this.getDomainTransportTypeConversionService().canConvert(sourceType, targetType)) {
            return (Collection)this.getDomainTransportTypeConversionService().convert(sourceCollection, sourceType, targetType);
        }
        for (S sourceObject : sourceCollection) {
            targetCollection.add(this.convert(sourceObject, itemSourceType, itemTargetType));
        }
        return targetCollection;
    }

    private <S, T> void convertNode(OSRole<?> role, BeanWrapperImpl convertFrom, BeanWrapperImpl convertTo, ConversionDirection conversionDirection, IdentityHashMap<Object, Object> processedObjects, String propertyPath) {
        this.assertNotNull(role, convertFrom, convertTo, conversionDirection, propertyPath);
        Object fromObject = null;
        Object object = fromObject = role.isRoot() ? convertFrom.getRootInstance() : convertFrom.getPropertyValue(propertyPath);
        if (fromObject == null) {
            return;
        }
        Object processedObject = processedObjects.get(fromObject);
        if (processedObject != null) {
            convertTo.setPropertyValue(propertyPath, processedObject);
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Started convertNode() for role: [" + role + "], propertyPath: ['" + propertyPath + "]', isRoot: [" + role.isRoot() + "]");
        }
        Object shallowCopy = null;
        DomainTransportTransfer<S, T> converter = this.getConverterForRole(role);
        shallowCopy = fromObject instanceof Collection ? this.handleCollection(role, conversionDirection, processedObjects, propertyPath, (Collection)fromObject) : this.createShallowCopy(conversionDirection, fromObject, converter);
        processedObjects.put(fromObject, shallowCopy);
        if (role.isRoot()) {
            convertTo.setWrappedInstance(shallowCopy);
        } else if (role.getRelationCardinality() == RelationCardinality.MANY) {
            HashSet convertedCollection = (HashSet)convertTo.getPropertyValue(propertyPath);
            if (shallowCopy != null && convertedCollection == null) {
                convertedCollection = new HashSet();
                convertTo.setPropertyValue(propertyPath, convertedCollection);
            }
            if (shallowCopy != null) {
                convertedCollection.addAll((Collection)shallowCopy);
            }
        } else {
            convertTo.setPropertyValue(propertyPath, shallowCopy);
            this.handleIfNavigateToParent((BeanWrapper)convertFrom, processedObjects, (BeanWrapper)convertTo, converter);
        }
        this.handleIfParentOne(role, convertFrom, convertTo, conversionDirection, processedObjects);
        if (logger.isTraceEnabled()) {
            logger.trace("End convertNode() for role: [" + role + "], propertyPath: ['" + propertyPath + "'], isRoot: [" + role.isRoot() + "]");
        }
    }

    private <S, T> void handleIfNavigateToParent(BeanWrapper convertFrom, IdentityHashMap<Object, Object> processedObjects, BeanWrapper convertTo, DomainTransportTransfer<S, T> converter) {
        if (converter.getParentAssociationRoleName() != null) {
            Object parent = convertFrom.getPropertyValue(converter.getParentAssociationRoleName());
            Object convertedParent = processedObjects.get(parent);
            if (convertedParent == null) {
                logger.warn("Parent association not found in object graph for property name " + converter.getParentAssociationRoleName());
            } else if (convertTo.isWritableProperty(converter.getParentAssociationRoleName())) {
                convertTo.setPropertyValue(converter.getParentAssociationRoleName(), convertedParent);
            } else {
                logger.warn(String.format("Cannot set navigation to parent, property '%s' isn't writeable on class '%s'", converter.getParentAssociationRoleName(), convertTo.getWrappedClass()));
            }
        }
    }

    private <S, T> Object handleCollection(OSRole<?> role, ConversionDirection conversionDirection, IdentityHashMap<Object, Object> processedObjects, String propertyPath, Collection fromObject) {
        BeanWrapperImpl newWrapperFrom = new BeanWrapperImpl();
        BeanWrapperImpl newWrapperTo = new BeanWrapperImpl();
        DomainTransportTransfer<S, T> converter = this.getConverterForRole(role);
        Collection convertedCollection = null;
        if (fromObject.size() > 0) {
            convertedCollection = CollectionFactory.createApproximateCollection((Object)fromObject, (int)16);
            for (Object toConvert : fromObject) {
                Object convertedObject = this.createShallowCopy(conversionDirection, toConvert, converter);
                convertedCollection.add(convertedObject);
                processedObjects.put(toConvert, convertedObject);
                newWrapperFrom.setWrappedInstance(toConvert);
                newWrapperTo.setWrappedInstance(convertedObject);
                this.handleIfNavigateToParent((BeanWrapper)newWrapperFrom, processedObjects, (BeanWrapper)newWrapperTo, converter);
                this.handleIfParentMany(role, newWrapperFrom, newWrapperTo, conversionDirection, processedObjects);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Handled Collection for role: [" + role + "], propertyPath: ['" + propertyPath + "']");
            }
        }
        return convertedCollection;
    }

    private <S, T> Object createShallowCopy(ConversionDirection conversionDirection, Object source, DomainTransportTransfer<S, T> converter) {
        Class<?> targetType = this.getTargetType(conversionDirection, converter);
        Object target = BeanUtils.instantiate(targetType);
        if (conversionDirection == ConversionDirection.DOMAIN2TRANSPORT) {
            converter.transferToTransport(source, target);
        } else {
            converter.transferToDomain(source, target);
        }
        return target;
    }

    <S, T> DomainTransportTransfer<S, T> getConverterForRole(OSRole<?> role) {
        DomainTransportTransfer converter = this.getDomainTransportConverterRegistry().getConverter(role);
        Assert.notNull(converter, (String)("Converter not found for role '" + role + "'"));
        return converter;
    }

    private <S, T> Class<?> getTargetType(ConversionDirection conversionDirection, DomainTransportTransfer<S, T> converter) {
        return conversionDirection == ConversionDirection.DOMAIN2TRANSPORT ? converter.getTransportType() : converter.getDomainType();
    }

    private <D> void handleIfParentOne(OSRole<D> parentRole, BeanWrapperImpl convertFrom, BeanWrapperImpl convertTo, ConversionDirection direction, IdentityHashMap<Object, Object> processedObjects) {
        for (OSRole<?> childRole : parentRole.getChildren()) {
            if (parentRole.isMany()) continue;
            String newPropertyPath = this.getFullPropertyPath(childRole);
            if (logger.isTraceEnabled()) {
                logger.trace("handleIfParentOne() for role: [" + childRole + "] with propertyPath ['" + newPropertyPath + "']");
            }
            this.convertNode(childRole, convertFrom, convertTo, direction, processedObjects, newPropertyPath);
        }
    }

    private <D> void handleIfParentMany(OSRole<D> parentRole, BeanWrapperImpl convertFrom, BeanWrapperImpl convertTo, ConversionDirection direction, IdentityHashMap<Object, Object> processedObjects) {
        if (logger.isTraceEnabled()) {
            logger.trace("handleIfParentMany() for role: [" + parentRole + "]");
        }
        for (OSRole<?> childRole : parentRole.getChildren()) {
            if (logger.isTraceEnabled()) {
                logger.trace("handleIfParentMany() for role: [" + parentRole + "] for child " + childRole + ": ParentIsMany: " + parentRole.isMany() + " IsNavigableToParent: " + childRole.isNavigableToParent() + " IsUpRelated: " + childRole.isUpRelated());
            }
            if (!parentRole.isMany() || !childRole.isNavigableToParent() && !childRole.isUpRelated()) continue;
            String newPropertyPath = this.getLastPropertyPathElement(childRole);
            if (logger.isTraceEnabled()) {
                logger.trace("handleIfParentMany(), handling property for child role: [" + childRole + "] with propertyPath ['" + newPropertyPath + "']");
            }
            this.convertNode(childRole, convertFrom, convertTo, direction, processedObjects, newPropertyPath);
        }
    }

    String getFullPropertyPath(OSRole<?> oSRole) {
        Assert.isInstanceOf(AssociationRoleConstant.class, (Object)oSRole.getRoleConstant());
        AssociationRoleConstant roleConstant = (AssociationRoleConstant)((Object)oSRole.getRoleConstant());
        String fullPropertyPath = null;
        if (oSRole.getParent().isRoot()) {
            fullPropertyPath = String.valueOf(roleConstant.getAssociationRoleName());
        } else if (oSRole.isMany()) {
            fullPropertyPath = this.getFullPropertyPath(oSRole.getParent()) + "." + roleConstant.getAssociationRoleName();
        } else {
            StringBuilder sb = new StringBuilder();
            Iterator<RoleConstant> it = oSRole.getRoleConstant().getRolePath().iterator();
            while (it.hasNext()) {
                AssociationRoleConstant rc = (AssociationRoleConstant)((Object)it.next());
                sb.append(rc.getAssociationRoleName());
                if (!it.hasNext()) continue;
                sb.append(".");
            }
            fullPropertyPath = sb.toString();
        }
        return fullPropertyPath;
    }

    String getLastPropertyPathElement(OSRole<?> oSRole) {
        String fullPath = this.getFullPropertyPath(oSRole);
        return fullPath.substring(PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)fullPath) + 1);
    }

    DomainTransportConverterRegistry getDomainTransportConverterRegistry() {
        return this.domainTransportConverterRegistry;
    }

    @Autowired
    @Required
    public void setDomainTransportConverterRegistry(DomainTransportConverterRegistry domainTransportConverterRegistry) {
        this.domainTransportConverterRegistry = domainTransportConverterRegistry;
    }

    ConversionService getDomainTransportTypeConversionService() {
        return this.domainTransportTypeConversionService;
    }

    @Autowired
    @Required
    public void setDomainTransportTypeConversionService(ConversionService domainTransportTypeConversionService) {
        this.domainTransportTypeConversionService = domainTransportTypeConversionService;
    }

    private void assertNotNull(OSRole<?> role, BeanWrapperImpl convertFrom, BeanWrapperImpl convertTo, ConversionDirection direction, String associationPath) {
        Assert.notNull(role, (String)"role must not be null");
        Assert.notNull((Object)convertFrom, (String)"convertFrom must not be null");
        Assert.notNull((Object)convertTo, (String)"convertTo must not be null");
        Assert.notNull((Object)((Object)direction), (String)"direction must not be null");
        Assert.notNull((Object)associationPath, (String)"associationPath must not be null");
    }

    private static enum ConversionDirection {
        DOMAIN2TRANSPORT,
        TRANSPORT2DOMAIN;

    }
}

