/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.transport;

import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import no.g9.os.OSRole;
import no.g9.support.transport.DomainTransportConversionService;
import no.g9.support.transport.DomainTransportTransfer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.convert.ConversionService;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.util.Assert;

public class DomainTransportMarshaller
implements Marshaller,
Unmarshaller,
InitializingBean {
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private ConversionService domainTransportConversionService;
    private Class<?> transportType;
    private Class<?> domainType;
    private OSRole<?> role;

    public Object unmarshal(Source source) throws IOException, XmlMappingException {
        Object unmarshalled = this.getUnmarshaller().unmarshal(source);
        return this.getDomainTransportConversionService().convert(unmarshalled, this.getDomainType());
    }

    public void marshal(Object graph, Result result) throws IOException, XmlMappingException {
        Object convertedGraph = this.getDomainTransportConversionService().convert(graph, this.getTransportType());
        this.getMarshaller().marshal(convertedGraph, result);
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    private Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Required
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    private Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    @Required
    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    private ConversionService getDomainTransportConversionService() {
        return this.domainTransportConversionService;
    }

    @Required
    public void setDomainTransportConversionService(ConversionService domainTransportConversionService) {
        this.domainTransportConversionService = domainTransportConversionService;
    }

    private Class<?> getTransportType() {
        return this.transportType;
    }

    private Class<?> getDomainType() {
        return this.domainType;
    }

    public OSRole<?> getRole() {
        return this.role;
    }

    @Required
    public void setRole(OSRole<?> role) {
        this.role = role;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isInstanceOf(DomainTransportConversionService.class, (Object)this.getDomainTransportConversionService());
        DomainTransportTransfer transfer = ((DomainTransportConversionService)this.getDomainTransportConversionService()).getConverterForRole(this.role);
        Assert.notNull(transfer, (String)"No DomainTransportConversionService found");
        this.domainType = transfer.getDomainType();
        this.transportType = transfer.getTransportType();
    }
}

