/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.transport;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import no.g9.exception.G9BaseException;
import no.g9.support.Numeric;
import org.springframework.core.convert.converter.Converter;

public class TransportTypeConversion {

    public static final class XMLGregorianCalendarToDate
    implements Converter<XMLGregorianCalendar, Date> {
        public Date convert(XMLGregorianCalendar source) {
            return source.toGregorianCalendar().getTime();
        }
    }

    public static final class DateToXMLGregorianCalendar
    implements Converter<Date, XMLGregorianCalendar> {
        public XMLGregorianCalendar convert(Date source) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(source);
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)cal);
            }
            catch (DatatypeConfigurationException e) {
                throw new G9BaseException("Failed to convert date to XMLGregorianCalendar", e);
            }
        }
    }

    public static final class BigDecimalToNumeric
    implements Converter<BigDecimal, Numeric> {
        public Numeric convert(BigDecimal source) {
            return new Numeric(source, source.scale());
        }
    }

    public static final class NumericToBigDecimal
    implements Converter<Numeric, BigDecimal> {
        public BigDecimal convert(Numeric source) {
            return source.getValue();
        }
    }
}

