/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import no.esito.log.Logger;
import no.esito.util.DateUtil;
import no.g9.client.core.view.faces.ConverterHelper;

public class DateTimeConverter
extends javax.faces.convert.DateTimeConverter {
    private static final Logger log = Logger.getLogger(DateTimeConverter.class);

    public DateTimeConverter() {
        this.setTimeZone(TimeZone.getDefault());
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        this.setPatternFromComponent(component);
        return super.getAsString(context, component, value);
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        try {
            this.setPatternFromComponent(component);
            DateFormat parser = null;
            if (this.getType().equals("date") || this.getType().equals("timestamp")) {
                parser = this.parseLocaleFormat(value);
                if (parser == null && (parser = DateUtil.getParseFormat((String)value, (Locale)this.getLocale())) == null) {
                    parser = this.getDateFormat();
                }
                if (parser == null) {
                    throw new ParseException("No date parser available", 0);
                }
            } else {
                parser = this.getDateFormat();
            }
            return parser.parse(value);
        }
        catch (Exception e) {
            throw new ConverterException(ConverterHelper.getConversionErrorMessage(component));
        }
    }

    private DateFormat parseLocaleFormat(String value) {
        DateFormat localeDateFormat = DateFormat.getDateInstance(2, this.getLocale());
        localeDateFormat.setLenient(false);
        try {
            localeDateFormat.parse(value);
        }
        catch (ParseException e) {
            localeDateFormat = null;
        }
        return localeDateFormat;
    }

    private DateFormat getDateFormat() {
        if (this.getPattern() == null && this.getType() == null) {
            throw new IllegalArgumentException("Either pattern or type must be specified.");
        }
        DateFormat df = null;
        String format = this.getPattern();
        if (format != null && !format.isEmpty()) {
            df = new SimpleDateFormat(format, this.getLocale());
        } else if (this.getType().equals("both")) {
            df = DateFormat.getDateTimeInstance(this.getStyle(this.getDateStyle()), this.getStyle(this.getTimeStyle()), this.getLocale());
        } else if (this.getType().equals("date")) {
            df = DateFormat.getDateInstance(this.getStyle(this.getDateStyle()), this.getLocale());
        } else if (this.getType().equals("time")) {
            df = DateFormat.getTimeInstance(this.getStyle(this.getTimeStyle()), this.getLocale());
        } else {
            throw new IllegalArgumentException("Invalid type: " + this.getType());
        }
        df.setLenient(false);
        return df;
    }

    private int getStyle(String name) {
        if (name.equals("short")) {
            return 3;
        }
        if (name.equals("medium")) {
            return 2;
        }
        if (name.equals("long")) {
            return 1;
        }
        if (name.equals("full")) {
            return 0;
        }
        return 2;
    }

    private void setPatternFromComponent(UIComponent component) {
        if (this.getPattern() == null) {
            String pattern = (String)component.getAttributes().get("pattern");
            log.trace((Object)("Pattern from component: " + pattern));
            this.setPattern(pattern);
        }
    }
}

