/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import no.g9.support.G9Enumerator;
import no.g9.support.ObjectFactory;

public class EnumConverter
implements Converter,
StateHolder {
    private String enumClassName = null;
    private boolean transientFlag = false;
    protected static final Map<String, String> titles = new HashMap<String, String>();
    public static final String NULL_VALUE = "EnumConverter.NULL_VALUE";
    private static final String NAME_METHOD = "name";
    private static final String GET_BY_NAME_METHOD = "getByName";

    public String getEnumClass() {
        return this.enumClassName;
    }

    public void setEnumClass(String enumClass) {
        this.enumClassName = enumClass;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        G9Enumerator retVal = null;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return null;
        }
        if (value.isEmpty() || NULL_VALUE.equals(value)) {
            return null;
        }
        if (titles.get(value) == null) {
            throw new ConverterException("Unknown title for enum value: " + value);
        }
        try {
            String enumValueName = titles.get(value).trim();
            if (this.isJavaEnumClass()) {
                retVal = this.getEnumObject(enumValueName);
            } else {
                G9Enumerator geVal = (G9Enumerator)ObjectFactory.newObject((String)this.enumClassName);
                geVal.assignFromName(enumValueName);
                retVal = geVal;
            }
        }
        catch (ConverterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
        return retVal;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null || NULL_VALUE.equals(value)) {
            return NULL_VALUE;
        }
        String name = null;
        if (value instanceof G9Enumerator) {
            G9Enumerator enumVal = (G9Enumerator)value;
            name = enumVal.currentAsName();
            if (name == null) {
                throw new ConverterException("Unknown enumeration value: " + enumVal.currentValue);
            }
        } else if (value instanceof Enum) {
            name = this.getEnumName(value);
        } else {
            throw new ConverterException("Unknown class for enumeration value: " + value.getClass());
        }
        return this.getTitle(context, name);
    }

    private boolean isJavaEnumClass() {
        try {
            Class<?> enumClass = Class.forName(this.enumClassName);
            return enumClass.isEnum();
        }
        catch (ClassNotFoundException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private Enum<?> getEnumObject(String name) {
        try {
            Class<?> enumClass = Class.forName(this.enumClassName);
            Method getByName = enumClass.getMethod(GET_BY_NAME_METHOD, String.class);
            return (Enum)getByName.invoke(null, name);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private String getEnumName(Object enumObject) {
        try {
            Method name = enumObject.getClass().getMethod(NAME_METHOD, null);
            return (String)name.invoke(enumObject, (Object[])null);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public Object saveState(FacesContext context) {
        return this.enumClassName;
    }

    public void restoreState(FacesContext context, Object state) {
        this.enumClassName = (String)state;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    private String getTitle(FacesContext context, String name) {
        String title = this.getTitleFromMap(name);
        if (title == null) {
            String key = this.makeKey(name);
            ResourceBundle bundle = this.getBundle(context);
            try {
                title = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                title = "???" + key + "???";
            }
            titles.put(title, name);
        }
        return title;
    }

    private String getTitleFromMap(String name) {
        if (name != null) {
            for (String title : titles.keySet()) {
                if (!name.equals(titles.get(title))) continue;
                return title;
            }
        }
        return null;
    }

    private ResourceBundle getBundle(FacesContext context) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        String bundleName = context.getApplication().getMessageBundle();
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, context.getViewRoot().getLocale(), loader);
        return bundle;
    }

    private String makeKey(String name) {
        String enumName = this.getEnumClass();
        int i = enumName.lastIndexOf(46);
        if (i != -1) {
            enumName = enumName.substring(i + 1);
        }
        return enumName + "." + name.toUpperCase() + ".title";
    }
}

