/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import java.lang.constant.Constable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.esito.log.Logger;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.faces.FacesDialogBean;
import no.g9.client.core.view.table.DefaultTableModel;
import no.g9.client.core.view.table.ListRowComparator;
import no.g9.client.core.view.table.TableModel;
import no.g9.os.RoleConstant;

public final class FacesComparatorMap
implements Map<Object, Object> {
    private static final Logger log = Logger.getLogger(FacesComparatorMap.class);
    private FacesDialogBean jsfBean;
    private ComparatorPropertyType comparatorPropertyType;
    private Map<String, DialogObjectConstant> enumMap = new HashMap<String, DialogObjectConstant>();

    public FacesComparatorMap(Class<Enum<?>> enumType, FacesDialogBean jsfBean, ComparatorPropertyType comparatorPropertyType) {
        Enum<?>[] enumConstants;
        this.jsfBean = jsfBean;
        this.comparatorPropertyType = comparatorPropertyType;
        for (Enum<?> enum1 : enumConstants = enumType.getEnumConstants()) {
            if (!(enum1 instanceof DialogObjectConstant)) continue;
            DialogObjectConstant tmp = (DialogObjectConstant)enum1;
            this.enumMap.put(tmp.getInternalName(), tmp);
        }
    }

    @Override
    public Object get(Object key) {
        Constable value;
        String internalName = (String)key;
        DialogObjectConstant column = this.enumMap.get(internalName);
        ListRowComparator<?> comparator = this.getComparator(column);
        if (this.comparatorPropertyType == ComparatorPropertyType.PRIORITY) {
            if (comparator.getSorting() == ListRowComparator.Sorting.NO_SORT) {
                value = 0;
            } else {
                TableModel tableModel = this.jsfBean.getViewModel().getTableModel(FacesComparatorMap.getTableRole(column));
                List comparators = ((DefaultTableModel)tableModel).getListRowComparator();
                int index = comparators.indexOf(comparator);
                value = index + 1;
            }
        } else {
            value = Boolean.valueOf(comparator.getSorting() == ListRowComparator.Sorting.ASCENDING);
        }
        log.trace((Object)("Get comparator property " + (Object)((Object)this.comparatorPropertyType) + " for " + key + ": " + value));
        return value;
    }

    @Override
    public Object put(Object key, Object value) {
        Object oldVal = this.get(key);
        String internalName = (String)key;
        DialogObjectConstant column = this.enumMap.get(internalName);
        ListRowComparator<?> comparator = this.getComparator(column);
        if (this.comparatorPropertyType == ComparatorPropertyType.PRIORITY) {
            TableModel tableModel = this.jsfBean.getViewModel().getTableModel(FacesComparatorMap.getTableRole(column));
            List comparators = ((DefaultTableModel)tableModel).getListRowComparator();
            comparators.remove(comparator);
            int priority = this.getPriority(value);
            if (priority == 0) {
                comparator.setSorting(ListRowComparator.Sorting.NO_SORT);
                comparators.add(comparator);
            } else {
                comparators.add(priority - 1, comparator);
            }
            tableModel.setListRowComparator(comparators);
        } else {
            boolean ascending = this.getAscending(value);
            comparator.setSorting(ascending ? ListRowComparator.Sorting.ASCENDING : ListRowComparator.Sorting.DESCENDING);
        }
        log.trace((Object)("Set comparator property " + (Object)((Object)this.comparatorPropertyType) + " for " + key + " to: " + value));
        return oldVal;
    }

    private int getPriority(Object value) {
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    private boolean getAscending(Object value) {
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    private ListRowComparator<?> getComparator(DialogObjectConstant column) {
        if (FacesComparatorMap.getTableRole(column) != null) {
            TableModel tableModel = this.jsfBean.getViewModel().getTableModel(FacesComparatorMap.getTableRole(column));
            for (ListRowComparator comparator : ((DefaultTableModel)tableModel).getListRowComparator()) {
                if (!comparator.getColumn().equals(column)) continue;
                return comparator;
            }
        }
        return null;
    }

    private static RoleConstant getTableRole(DialogObjectConstant column) {
        DialogObjectConstant table = (DialogObjectConstant)column.getParent();
        if (table != null) {
            return table.getRole();
        }
        return null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Object> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    public static enum ComparatorPropertyType {
        PRIORITY,
        ASCENDING;

    }
}

