/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.event.ActionEvent;
import no.esito.jvine.communication.SystemMessageUtils;
import no.esito.jvine.controller.DialogInstanceKey;
import no.esito.jvine.view.ViewModelImpl;
import no.g9.client.core.communication.SystemMessage;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogInstance;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.controller.DialogObjectType;
import no.g9.client.core.view.BooleanProperty;
import no.g9.client.core.view.EffectProperty;
import no.g9.client.core.view.ListRow;
import no.g9.client.core.view.faces.FacesApplicationBean;
import no.g9.client.core.view.faces.FacesApplicationView;
import no.g9.client.core.view.faces.FacesComparatorMap;
import no.g9.client.core.view.faces.FacesDialogView;
import no.g9.client.core.view.faces.FacesPropertyMap;
import no.g9.client.core.view.faces.FacesTitleMap;
import no.g9.exception.G9BaseException;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.os.RoleConstant;
import org.icefaces.ace.component.submenu.Submenu;
import org.icefaces.ace.model.MenuModel;
import org.icefaces.ace.model.table.RowStateMap;
import org.icefaces.ace.model.tree.NodeStateMap;
import org.springframework.util.StringUtils;

public abstract class FacesDialogBean
implements Serializable {
    private DialogInstance instance;
    private DialogConstant tmpDialog;
    private String messageBundleName;
    private FacesApplicationBean applicationBean;
    private FacesPropertyMap<BooleanProperty> propertyEditable;
    private FacesPropertyMap<BooleanProperty> propertyEnabled;
    private FacesPropertyMap<BooleanProperty> propertyMandatory;
    private FacesPropertyMap<BooleanProperty> propertyShown;
    private FacesPropertyMap<BooleanProperty> propertyExpanded;
    private FacesPropertyMap<EffectProperty> propertyEffect;
    private FacesTitleMap propertyTitle;
    private FacesComparatorMap propertySortPriority;
    private FacesComparatorMap propertySortAscending;

    public FacesDialogBean(DialogConstant dialog) {
        this.tmpDialog = dialog;
    }

    public Map<?, ?> getEditable() {
        return this.propertyEditable;
    }

    public Map<?, ?> getEnabled() {
        return this.propertyEnabled;
    }

    public Map<?, ?> getMandatory() {
        return this.propertyMandatory;
    }

    public Map<?, ?> getShown() {
        return this.propertyShown;
    }

    public Map<?, ?> getExpanded() {
        return this.propertyExpanded;
    }

    public Map<?, ?> getEffect() {
        return this.propertyEffect;
    }

    public Map<?, ?> getTitle() {
        return this.propertyTitle;
    }

    public Map<?, ?> getSortPriority() {
        return this.propertySortPriority;
    }

    public Map<?, ?> getSortAscending() {
        return this.propertySortAscending;
    }

    protected RowStateMap getRowStateMap(RoleConstant role) {
        return ((FacesDialogView)((Object)this.getDialogView())).getRowStateMap(role);
    }

    protected void updateRowState(RoleConstant role) {
        ((FacesDialogView)((Object)this.getDialogView())).updateRowState(role);
    }

    protected NodeStateMap getNodeStateMap(DialogObjectConstant diaConst) {
        return ((FacesDialogView)((Object)this.getDialogView())).getNodeStateMap(diaConst);
    }

    protected void setNodeStateMap(DialogObjectConstant diaConst, NodeStateMap nodeStateMap) {
        ((FacesDialogView)((Object)this.getDialogView())).setNodeStateMap(diaConst, nodeStateMap);
    }

    protected void initPropertyMaps(Class enumClass) {
        this.propertyEditable = new FacesPropertyMap(enumClass, this, BooleanProperty.EDITABLE);
        this.propertyEnabled = new FacesPropertyMap(enumClass, this, BooleanProperty.ENABLED);
        this.propertyMandatory = new FacesPropertyMap(enumClass, this, BooleanProperty.MANDATORY);
        this.propertyShown = new FacesPropertyMap(enumClass, this, BooleanProperty.SHOWN);
        this.propertyExpanded = new FacesPropertyMap(enumClass, this, BooleanProperty.EXPANDED);
        this.propertyEffect = new FacesPropertyMap(enumClass, this, EffectProperty.STD_EFFECT);
        this.propertyTitle = new FacesTitleMap(enumClass, this.getViewModel().getDialogController().getDialogView());
        this.propertySortPriority = new FacesComparatorMap(enumClass, this, FacesComparatorMap.ComparatorPropertyType.PRIORITY);
        this.propertySortAscending = new FacesComparatorMap(enumClass, this, FacesComparatorMap.ComparatorPropertyType.ASCENDING);
    }

    protected DialogObjectConstant getCurrentNotebookPage(DialogObjectConstant notebook) {
        return this.getDialogView().getCurrentNotebookPage(notebook);
    }

    protected void setCurrentNotebookPage(DialogObjectConstant notebook, DialogObjectConstant page) {
        this.getDialogView().setCurrentNotebookPage(notebook, page);
    }

    protected int getCurrentNotebookIndex(DialogObjectConstant notebook) {
        return ((FacesDialogView)((Object)this.getDialogView())).getCurrentNotebookIndex(notebook);
    }

    protected void setCurrentNotebookIndex(DialogObjectConstant notebook, int index) {
        ((FacesDialogView)((Object)this.getDialogView())).setCurrentNotebookIndex(notebook, index);
    }

    protected int getOldNotebookIndex(DialogObjectConstant notebook) {
        return ((FacesDialogView)((Object)this.getDialogView())).getOldNotebookIndex(notebook);
    }

    protected void setOldNotebookIndex(DialogObjectConstant notebook, int index) {
        ((FacesDialogView)((Object)this.getDialogView())).setOldNotebookIndex(notebook, index);
    }

    protected boolean handleListSelection(RoleConstant listRole, boolean selected, int rowNo, ListRow emptyRow) {
        return ((FacesDialogView)((Object)this.getDialogView())).handleListSelection(listRole, selected, rowNo, emptyRow);
    }

    protected void setListSelectionRowNum(int rowNum) {
        ((FacesDialogView)((Object)this.getDialogView())).setListSelectionRowNum(rowNum);
    }

    protected void show(DialogObjectConstant target) {
        this.getDialogView().show(target);
    }

    protected void hide(DialogObjectConstant target) {
        this.getDialogView().hide(target);
    }

    protected void dispatchEvent(DialogObjectConstant trigger, Object event, String method) {
        this.clearOuputMessageQueue();
        this.dispatchEvent(null, trigger, event, method);
        this.sendOutputMessageQueue();
    }

    protected void dispatchSystemMessages(DialogObjectConstant trigger, String systemMessagesInJson) {
        if (this.getDialogView().canDispatchEvents()) {
            List messages = SystemMessageUtils.fromJSon((String)systemMessagesInJson);
            for (SystemMessage systemMessage : messages) {
                if ("_application_menu".equals(systemMessage.port)) {
                    this.dispatchEvent(trigger, systemMessage, systemMessage.payload);
                    continue;
                }
                this.clearOuputMessageQueue();
                this.getApplicationBean().getApplicationView().getApplicationController().forward(systemMessage);
                this.sendOutputMessageQueue();
            }
        } else {
            this.getApplicationBean().getApplicationView().sendElevateMessage();
            this.sendOutputMessageQueue();
        }
    }

    private void clearOuputMessageQueue() {
        this.getApplicationBean().getApplicationView().getOutputMessages().clear();
    }

    private void sendOutputMessageQueue() {
        for (SystemMessage outputMessage : this.getApplicationBean().getApplicationView().getOutputMessages()) {
            this.getApplicationBean().getApplicationView().forward(outputMessage);
        }
        this.clearOuputMessageQueue();
    }

    protected void dispatchEvent(ListRow listRow, DialogObjectConstant trigger, Object event, String method) {
        ((FacesDialogView)((Object)this.getDialogView())).dispatchEvent(listRow, trigger, event, method);
    }

    public String getDialogToolbarIncludePath() {
        return this.getApplicationBean().getDialogToolbarIncludePath();
    }

    public MenuModel getApplicationMenuModel() {
        return this.getApplicationBean().getApplicationView().getApplicationMenuModel();
    }

    public List<Submenu> getApplicationMenu() {
        return this.getApplicationBean().getApplicationView().getApplicationMenu();
    }

    public String msg(String key) {
        return this.getApplicationBean().getFacesMessage(this.getMessageBundleName(), key);
    }

    protected void copyToEquivalentFields(DialogObjectConstant field, Object value) {
        this.getViewModel().copyToEquivalentFields(field, value);
    }

    protected Object getField(DialogObjectConstant field) {
        return this.getViewModel().getField(field);
    }

    protected void setField(DialogObjectConstant field, Object value) {
        this.getViewModel().setField(field, value);
    }

    protected Object getFieldValue(DialogObjectConstant field) {
        return this.getViewModel().getFieldValue(field);
    }

    protected void setFieldValue(DialogObjectConstant field, Object fieldValue) {
        this.getViewModel().setFieldValue(field, fieldValue);
    }

    protected Collection<DialogObjectConstant> getRoleFields(RoleConstant role) {
        return this.getViewModel().getRoleFields(role);
    }

    public FacesApplicationBean getApplicationBean() {
        return this.applicationBean;
    }

    public void setApplicationBean(FacesApplicationBean applicationBean) {
        this.applicationBean = applicationBean;
        if (this.instance != null) {
            this.initInstance();
        }
    }

    public int getDialogInstanceNumber() {
        return this.instance.getDialogInstanceNumber();
    }

    public void setDialogInstanceNumber(int dialogInstanceNumber) {
        this.instance = new DialogInstanceKey(this.tmpDialog, dialogInstanceNumber);
        if (this.applicationBean != null) {
            this.initInstance();
        }
    }

    public void setAsActiveInstance() {
        Object view = this.getDialogView();
        ((FacesDialogView)((Object)view)).getApplicationView().getApplicationController().setActiveDialogInstance(view.getDialogInstance());
    }

    private void initInstance() {
        if (this.instance == null) {
            throw new IllegalStateException("Trying to initialize an unknown instance");
        }
        if (this.applicationBean == null) {
            throw new IllegalStateException("Trying to initialize an instance without an application");
        }
        FacesApplicationView appView = this.applicationBean.getApplicationView();
        FacesDialogView dialogView = (FacesDialogView)appView.createDialogView(this.instance);
        this.setMessageBundleName(dialogView.getMessageBundleName());
        this.initBean();
        dialogView.setOpen(true);
    }

    protected abstract void initBean();

    protected <T extends FacesDialogView> T getDialogView() {
        FacesApplicationView appView = this.getApplicationBean().getApplicationView();
        return (T)((Object)((FacesDialogView)appView.getDialogView(this.instance)));
    }

    protected boolean hasOpenDialogView() {
        FacesApplicationView appView = this.getApplicationBean().getApplicationView();
        return appView.hasOpenDialogView(this.instance);
    }

    protected ViewModelImpl getViewModel() {
        return (ViewModelImpl)this.getDialogView().getViewModel();
    }

    protected boolean validateField(DialogObjectConstant field, Object newValue, Object oldValue) {
        return this.validateField(null, field, newValue, oldValue);
    }

    protected boolean validateField(ListRow listRow, DialogObjectConstant field, Object newValue, Object oldValue) {
        return ((FacesDialogView)((Object)this.getDialogView())).validateField(listRow, field, newValue);
    }

    public String getDialogTitle() {
        return this.getApplicationBean().getDialogTitle(this.instance);
    }

    protected ListRow getListRow(RoleConstant listRole, Object contextValue) {
        if (contextValue instanceof ListRow) {
            return (ListRow)contextValue;
        }
        if (contextValue instanceof String) {
            String rowId = (String)contextValue;
            List list = this.getViewModel().getDisplayList(listRole);
            ListRow listRow = null;
            for (ListRow row : list) {
                if (!rowId.equals(row.toString())) continue;
                listRow = row;
                break;
            }
            return listRow;
        }
        return null;
    }

    public String getMessageBundleName() {
        return this.messageBundleName;
    }

    private void setMessageBundleName(String messageBundleName) {
        this.messageBundleName = messageBundleName;
    }

    public void defaultButtonActionListener(ActionEvent event) {
        DialogObjectConstant defaultButton = this.getDialogView().getDefaultButton();
        if (defaultButton != null && defaultButton.getType() == DialogObjectType.Button) {
            String methodName = StringUtils.uncapitalize((String)defaultButton.getG9Name()) + "_Clicked";
            try {
                Method method = this.getClass().getMethod(methodName, ActionEvent.class);
                method.invoke((Object)this, event);
            }
            catch (Exception e) {
                String msg = "Failed to execute action listener method " + methodName;
                Message message = MessageSystem.getMessageFactory().getMessage("-1517", new Object[]{msg});
                message.setException((Throwable)e);
                throw new G9BaseException(message);
            }
        }
    }

    protected String getFacesId(DialogObjectConstant target) {
        return ((FacesDialogView)((Object)this.getDialogView())).getFacesId(target);
    }

    protected UIComponent getFacesComponent(UIComponent comp, String key) {
        return ((FacesDialogView)((Object)this.getDialogView())).getFacesComponent(comp, key);
    }
}

