/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import no.esito.jvine.action.GuiTask;
import no.esito.jvine.view.AbstractDialogView;
import no.esito.jvine.view.ViewModelImpl;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.controller.DialogObjectType;
import no.g9.client.core.util.DialogObjectConstantHelper;
import no.g9.client.core.view.ListRow;
import no.g9.client.core.view.faces.FacesApplicationView;
import no.g9.client.core.view.faces.tree.FacesTreeNode;
import no.g9.client.core.view.menu.Menu;
import no.g9.client.core.view.table.TableModel;
import no.g9.os.RoleConstant;
import no.g9.support.ActionType;
import org.icefaces.ace.model.table.RowState;
import org.icefaces.ace.model.table.RowStateMap;
import org.icefaces.ace.model.tree.NodeState;
import org.icefaces.ace.model.tree.NodeStateMap;
import org.icefaces.util.JavaScriptRunner;

public abstract class FacesDialogView
extends AbstractDialogView {
    private List<Menu> dialogMenu = new ArrayList<Menu>();
    private Set<DialogObjectConstant> ignoreValuechangeFields = new HashSet<DialogObjectConstant>();
    private Map<DialogObjectConstant, Integer> currentNotebookIndex = new HashMap<DialogObjectConstant, Integer>();
    private Map<DialogObjectConstant, Integer> oldNotebookIndex = new HashMap<DialogObjectConstant, Integer>();
    private Class<Enum<?>> dialogObjectEnum;
    private final Map<RoleConstant, RowStateMap> rowStateMaps = new HashMap<RoleConstant, RowStateMap>();
    private final Map<DialogObjectConstant, NodeStateMap> nodeStateMaps = new HashMap<DialogObjectConstant, NodeStateMap>();

    public FacesDialogView(DialogConstant dialog, Class dialogObjectEnum) {
        super(dialog);
        this.dialogObjectEnum = dialogObjectEnum;
    }

    public void setProperty(DialogObjectConstant target, String key, Object value) {
        this.setAttribute(this.getFacesId(target), key, value);
    }

    protected UIComponent getFacesComponent(UIComponent comp, String key) {
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent currentComp = comp;
        if (currentComp == null) {
            currentComp = context.getViewRoot();
        }
        if (currentComp.getId() != null && currentComp.getId().equals(key)) {
            return currentComp;
        }
        for (Object child : currentComp.getChildren()) {
            UIComponent foundComp = this.getFacesComponent((UIComponent)child, key);
            if (foundComp == null) continue;
            return foundComp;
        }
        if (currentComp.getChildren() != null && currentComp.getChildren().size() == 0) {
            Iterator it = currentComp.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent foundComp = this.getFacesComponent((UIComponent)it.next(), key);
                if (foundComp == null) continue;
                return foundComp;
            }
        }
        return null;
    }

    protected String getFacesId(DialogObjectConstant target) {
        String id = target.getInternalName();
        String instanceName = this.getApplicationView().getDialogInstanceName(this.getDialogInstance());
        if (instanceName != null && !id.startsWith(instanceName)) {
            int ix = this.getApplicationView().getDialogName(this.getDialog()).length();
            id = instanceName + id.substring(ix);
        }
        return id;
    }

    protected RowStateMap getRowStateMap(RoleConstant role) {
        RowStateMap rowStateMap = this.rowStateMaps.get(role);
        if (rowStateMap == null) {
            rowStateMap = new RowStateMap();
            this.rowStateMaps.put(role, rowStateMap);
        }
        return rowStateMap;
    }

    protected void setRowStateMap(RoleConstant role, RowStateMap rowStateMap) {
        this.rowStateMaps.put(role, rowStateMap);
    }

    protected synchronized void updateRowState(RoleConstant role) {
        TableModel tableModel = this.getViewModel().getTableModel(role);
        RowStateMap stateMap = this.getRowStateMap(role);
        stateMap.setAllSelected(false);
        TableModel.SelectionModel selectionModel = tableModel.getSelectionModel();
        if (selectionModel == TableModel.SelectionModel.NO_SELECT) {
            stateMap.setAllSelectable(false);
        } else {
            for (ListRow row : tableModel.getSelected()) {
                RowState state = stateMap.get((Object)row);
                if (state == null) continue;
                state.setSelected(true);
            }
        }
    }

    protected NodeStateMap getNodeStateMap(DialogObjectConstant diaConst) {
        NodeStateMap nodeStateMap = this.nodeStateMaps.get(diaConst);
        if (nodeStateMap == null) {
            nodeStateMap = new NodeStateMap();
            this.nodeStateMaps.put(diaConst, nodeStateMap);
        }
        return nodeStateMap;
    }

    protected void setNodeStateMap(DialogObjectConstant diaConst, NodeStateMap nodeStateMap) {
        this.nodeStateMaps.put(diaConst, nodeStateMap);
    }

    private void setAttribute(final String expr, final String key, final Object value) {
        this.guiInvoke(new GuiTask(key){

            public void run() {
                UIComponent comp = FacesDialogView.this.getFacesComponent(null, expr);
                if (comp != null) {
                    comp.getAttributes().put(key, value);
                }
            }
        });
    }

    @Deprecated
    public void setValue(DialogObjectConstant target, String value) {
        this.setAttribute(this.getFacesId(target), "value", value);
    }

    protected void focus(final DialogObjectConstant target) {
        this.guiInvoke(new GuiTask("focus"){

            public void run() {
                String facesId = FacesDialogView.this.getFacesId(target);
                if (DialogObjectConstantHelper.isAutoCompleteEntry((DialogObjectConstant)target) || DialogObjectConstantHelper.isDateTimeEntry((DialogObjectConstant)target)) {
                    facesId = facesId + "_input";
                }
                JavaScriptRunner.runScript((FacesContext)FacesContext.getCurrentInstance(), (String)("ice.applyFocus('iceform:" + facesId + "');"));
            }
        });
    }

    protected Set<DialogObjectConstant> getIgnoreValuechangeFields() {
        return this.ignoreValuechangeFields;
    }

    protected void addMenu(Menu menu) {
        this.dialogMenu.add(menu);
    }

    protected List<Menu> setDialogInstanceNumberOnMenus(List<Menu> menus) {
        for (Menu menu : menus) {
            menu.setDialogInstance(this.getDialogInstanceNumber());
        }
        return menus;
    }

    public void addMenus(List<Menu> menus) {
        for (Menu menu : menus) {
            this.addMenu(menu);
        }
    }

    List<Menu> getDialogMenu() {
        return this.dialogMenu;
    }

    protected void setOpen(boolean isOpen) {
        super.setOpen(isOpen);
    }

    protected boolean handleListSelection(RoleConstant listRole, boolean selected, int rowNo, ListRow emptyRow) {
        return super.handleListSelection(listRole, selected, rowNo, emptyRow);
    }

    protected void setListSelectionRowNum(int rowNum) {
        super.setListSelectionRowNum(rowNum);
    }

    protected void dispatchEvent(DialogObjectConstant trigger, Object event, String method) {
        this.dispatchEvent(null, trigger, event, method);
    }

    public void dispatchEvent(ListRow listRow, DialogObjectConstant trigger, Object event, String method) {
        super.dispatchEvent(listRow, trigger, event, method);
    }

    public FacesApplicationView getApplicationView() {
        return (FacesApplicationView)super.getApplicationView();
    }

    public void performAction(ActionType action, DialogObjectConstant target) {
        super.performAction(action, target);
        switch (action) {
            case HIDE: 
            case SHOW: {
                ViewModelImpl model = (ViewModelImpl)this.getViewModel();
                Object effectBean = model.getPropertyManager().getEffect(target);
                if (effectBean == null) break;
                break;
            }
            case EXPAND: {
                this.expandNodeTypes(target, true);
                break;
            }
            case COLLAPSE: {
                this.expandNodeTypes(target, false);
                break;
            }
        }
    }

    private void expandNodeTypes(DialogObjectConstant target, boolean expand) {
        DialogObjectType objectType = target.getType();
        if (objectType.equals((Object)DialogObjectType.TreeNode)) {
            DialogObjectConstant parent = (DialogObjectConstant)target.getParent();
            while (!parent.getType().equals((Object)DialogObjectType.TreeView)) {
                parent = (DialogObjectConstant)parent.getParent();
            }
            NodeStateMap stateMap = this.nodeStateMaps.get(parent);
            for (Map.Entry entry : stateMap.entrySet()) {
                if (!((FacesTreeNode)entry.getKey()).getNodeConst().equals(target)) continue;
                ((NodeState)entry.getValue()).setExpanded(expand);
            }
        } else if (objectType.equals((Object)DialogObjectType.TreeView)) {
            this.nodeStateMaps.get(target).setAllExpanded(expand);
        }
    }

    public String createBeanRef(String beanName) {
        String retVal = beanName;
        if (this.getDialogInstanceNumber() > 1) {
            retVal = retVal + this.getDialogInstanceNumber();
        }
        return retVal;
    }

    public String createBeanRef() {
        return this.createBeanRef(this.getDialog().getG9Name().toLowerCase());
    }

    boolean validateField(ListRow listRow, DialogObjectConstant field, Object newValue) {
        return this.getApplicationView().getDialogController(this.getDialog()).validateField(listRow, field, newValue);
    }

    protected void setCurrentNotebookIndex(DialogObjectConstant notebook, int index) {
        int oldIndex = this.getCurrentNotebookIndex(notebook);
        if (index != oldIndex) {
            this.setOldNotebookIndex(notebook, oldIndex);
            this.currentNotebookIndex.put(notebook, index);
        }
    }

    protected int getCurrentNotebookIndex(DialogObjectConstant notebook) {
        Integer index = this.currentNotebookIndex.get(notebook);
        if (index == null) {
            return 0;
        }
        return index;
    }

    protected void setOldNotebookIndex(DialogObjectConstant notebook, int index) {
        this.oldNotebookIndex.put(notebook, index);
    }

    protected int getOldNotebookIndex(DialogObjectConstant notebook) {
        Integer index = this.oldNotebookIndex.get(notebook);
        if (index == null) {
            return 0;
        }
        return index;
    }

    public DialogObjectConstant getDialogObjectFromName(String name) {
        Enum<?>[] enumConstants;
        for (Enum<?> enum1 : enumConstants = this.dialogObjectEnum.getEnumConstants()) {
            DialogObjectConstant tmp = (DialogObjectConstant)enum1;
            if (!name.equals(tmp.getG9Name())) continue;
            return tmp;
        }
        return null;
    }

    public DialogObjectConstant getDialogObjectFromInternalName(String name) {
        Enum<?>[] enumConstants;
        for (Enum<?> enum1 : enumConstants = this.dialogObjectEnum.getEnumConstants()) {
            DialogObjectConstant tmp = (DialogObjectConstant)enum1;
            if (!name.equals(tmp.getInternalName())) continue;
            return tmp;
        }
        return null;
    }
}

