/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.esito.log.Logger;
import no.esito.util.ServiceLoader;
import no.g9.client.core.view.Resource;
import no.g9.client.core.view.ResourceStore;
import no.g9.service.G9Spring;

public class G9ResourceServlet
extends HttpServlet {
    public static final String URL_SUFFIX = "gva-resource";
    public static final String ID_PARAM = "id";
    public static final String PURGE_PARAM = "purge";
    public static final String TYPE_PARAM = "type";
    public static final String APPLICATION_MENU_TYPE = "application-menu";
    public static final String RESOURCE_TYPE = "resource";
    public static final String APPLICATION_MENU_BEAN = "gvaApplicationMenu";
    public static final String OBJECT_CONTENT_TYPE = "application/x-java-serialized-object";
    private static Logger logger = Logger.getLogger(G9ResourceServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourceType = request.getParameter(TYPE_PARAM);
        if (APPLICATION_MENU_TYPE.equals(resourceType)) {
            this.getApplicationMenu(response);
            return;
        }
        if (resourceType != null) {
            throw new ServletException("Invalid resource type parameter.");
        }
        String resourceId = request.getParameter(ID_PARAM);
        if (resourceId == null || resourceId.equals("")) {
            throw new ServletException("Invalid or non-existent resource id parameter.");
        }
        Resource resource = null;
        ResourceStore resourceStore = (ResourceStore)ServiceLoader.getService(ResourceStore.class);
        if (resourceStore != null) {
            resource = resourceStore.getResource(resourceId);
        }
        if (resource == null) {
            throw new ServletException("Non-existent resource for the given id parameter.");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Opening resource with id " + resourceId + " of type " + resource.getMimeType() + ", named " + resource.getResourceName()));
        }
        boolean purge = true;
        String purgeStr = request.getParameter(PURGE_PARAM);
        if (purgeStr != null && purgeStr.toUpperCase().equals("FALSE")) {
            purge = false;
        }
        ServletOutputStream stream = null;
        ByteArrayInputStream buf = null;
        String fileName = resource.getResourceName();
        String mimeType = resource.getMimeType();
        byte[] data = resource.getResource();
        try {
            stream = response.getOutputStream();
            response.setContentType(mimeType);
            response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setContentLength(data.length);
            buf = new ByteArrayInputStream(data);
            int readBytes = 0;
            while ((readBytes = buf.read()) != -1) {
                stream.write(readBytes);
            }
        }
        catch (IOException ioe) {
            throw new ServletException(ioe.getMessage());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (purge && resourceStore != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Purging resource with id " + resourceId));
                }
                resourceStore.removeResource(resourceId);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void getApplicationMenu(HttpServletResponse response) throws ServletException, IOException {
        Object menus = G9Spring.getBean((String)APPLICATION_MENU_BEAN);
        if (menus == null) {
            throw new ServletException("Resource type application-menu, bean not found.");
        }
        ObjectOutputStream stream = null;
        try {
            stream = new ObjectOutputStream((OutputStream)response.getOutputStream());
            stream.writeObject(menus);
            response.setContentType(OBJECT_CONTENT_TYPE);
        }
        catch (IOException ioe) {
            throw new ServletException(ioe.getMessage());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            response.getOutputStream().close();
        }
    }
}

