/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import no.esito.jvine.view.AbstractApplicationView;
import no.esito.jvine.view.faces.FacesMessageUtil;
import no.esito.log.Logger;
import no.g9.client.core.message.JVineDispatcherContext;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageLogger;
import no.g9.message.MessageTypeEnum;

public class InlineFacesMessageLogger
implements MessageLogger {
    private final Logger logger = Logger.getLogger(InlineFacesMessageLogger.class);

    public void log(Message message, DispatcherContext dispatcherContext) {
        if (message.getMsgType() != MessageTypeEnum.INLINE) {
            return;
        }
        if (dispatcherContext == null) {
            this.logger.error((Object)"Failed to communicate the message, the dispatcher context is null.");
            return;
        }
        JVineDispatcherContext dispatcher = (JVineDispatcherContext)dispatcherContext;
        try {
            AbstractApplicationView applicationView = (AbstractApplicationView)dispatcher.getApplicationView();
            applicationView.getApplicationController().invokeOnGui((Runnable)new InlineRunnable(message));
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static class InlineRunnable
    implements Runnable {
        private final Message message;

        public InlineRunnable(Message message) {
            this.message = message;
        }

        @Override
        public void run() {
            List messages = this.message.getMessages();
            if (messages.isEmpty()) {
                FacesMessageUtil.addContextMessage(this.message);
            } else {
                for (Message m : messages) {
                    Logger.getLogger(this.getClass()).debug((Object)m.getMessageText());
                    FacesMessageUtil.addContextMessage(m);
                }
            }
        }
    }
}

