/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import no.esito.jvine.view.ViewModelImpl;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.BooleanProperty;
import no.g9.client.core.view.ListRow;
import no.g9.client.core.view.Property;
import no.g9.client.core.view.ViewModel;
import no.g9.client.core.view.faces.tree.FacesNodeList;
import no.g9.client.core.view.faces.tree.FacesTreeNode;
import no.g9.client.core.view.table.RowFilter;
import no.g9.client.core.view.tree.TreeModel;
import no.g9.client.core.view.tree.TreeNodeComparator;
import org.icefaces.ace.model.tree.NodeStateMap;

public class FacesDefaultTreeModel<T extends FacesTreeNode, L extends ListRow>
implements TreeModel<T, L>,
Observer {
    private final NodeStateMap nodeStateMap;
    protected final FacesNodeList<T> treeView = new FacesNodeList();
    protected final FacesNodeList<T> treeData = new FacesNodeList();
    private final List<RowFilter<?, ListRow>> rowFilters = new ArrayList();
    protected final ViewModelImpl viewModel;
    protected TreeModel.SelectionModel selectionModel = TreeModel.SelectionModel.DEFAULT;
    private Map<DialogObjectConstant, TreeNodeComparator> comparatorMap = new HashMap<DialogObjectConstant, TreeNodeComparator>();

    public FacesDefaultTreeModel(ViewModel viewModel, NodeStateMap nodeStateMap) {
        this.viewModel = (ViewModelImpl)viewModel;
        this.nodeStateMap = nodeStateMap;
        this.treeData.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.filterTree(this.treeData, this.treeView);
        this.sortTree(this.treeView);
    }

    public FacesNodeList<T> getTreeView() {
        return this.treeView;
    }

    public FacesNodeList<T> getTreeData() {
        return this.treeData;
    }

    public Object getDataModel() {
        return this.treeView;
    }

    public void addRowFilter(RowFilter<?, ListRow> rowFilter) {
        this.rowFilters.add(rowFilter);
        this.filterTree(this.treeData, this.treeView);
    }

    public void addRowFilters(Collection<RowFilter<?, ListRow>> rowFilter) {
        this.rowFilters.addAll(this.rowFilters);
        this.filterTree(this.treeData, this.treeView);
    }

    public void removeRowFilter(RowFilter<?, ListRow> rowFilter) {
        this.rowFilters.remove(rowFilter);
        this.filterTree(this.treeData, this.treeView);
    }

    public void removeRowFilters(Collection<RowFilter<?, ListRow>> rowFilter) {
        this.rowFilters.removeAll(rowFilter);
        this.filterTree(this.treeData, this.treeView);
    }

    public void filterTree(List<T> srcList, List<T> dstList) {
        dstList.clear();
        FacesTreeNode currNode = null;
        FacesTreeNode currViewNode = null;
        FacesTreeNode currViewRootNode = null;
        Iterator<T> iterator = srcList.iterator();
        block0: while (iterator.hasNext()) {
            FacesTreeNode rootNode;
            currViewRootNode = currViewNode = (FacesTreeNode)rootNode.clone();
            for (currNode = rootNode = (FacesTreeNode)iterator.next(); currNode != null; currNode = (FacesTreeNode)currNode.getNextNode()) {
                if (this.passFilters(currNode)) {
                    if (currNode == rootNode) {
                        dstList.add(currViewRootNode);
                    } else {
                        currViewNode.add((FacesTreeNode)currNode.clone());
                    }
                    FacesTreeNode nxtNode = (FacesTreeNode)currNode.getNextNode();
                    if (nxtNode == null) {
                        currNode = null;
                        continue block0;
                    }
                    if (currNode.isNodeDescendant(nxtNode)) {
                        if (currNode == rootNode) continue;
                        currViewNode = (FacesTreeNode)currViewNode.getLastChild();
                        continue;
                    }
                    FacesTreeNode ancestorNode = (FacesTreeNode)currNode.getSharedAncestor(nxtNode);
                    int backtrack = currNode.getLevel() - ancestorNode.getLevel();
                    while (backtrack-- > 1) {
                        currViewNode = (FacesTreeNode)currViewNode.getParent();
                    }
                    continue;
                }
                while (currNode.isNodeDescendant(currNode.getNextNode())) {
                    currNode = (FacesTreeNode)currNode.getNextNode();
                }
            }
        }
    }

    private boolean passFilters(T node) {
        Object row = ((FacesTreeNode)node).getListRow();
        for (RowFilter<?, ListRow> filter : this.rowFilters) {
            if (filter.passFilter(row)) continue;
            return false;
        }
        return true;
    }

    public Object getValueAt(T node, DialogObjectConstant columnIdentifier) {
        return ((FacesTreeNode)node).getListRow().getValue(columnIdentifier);
    }

    public void setValueAt(T node, DialogObjectConstant columnIdentifier, Object value) {
        ((FacesTreeNode)node).getListRow().setValue(columnIdentifier, value);
    }

    public int getTreeDataNodeCount() {
        return this.nodeCount(this.treeData);
    }

    public int getTreeViewNodeCount() {
        return this.nodeCount(this.treeView);
    }

    private int nodeCount(List<T> rootNodeList) {
        int retval = 0;
        for (FacesTreeNode node : rootNodeList) {
            Enumeration<TreeNode> e = node.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                e.nextElement();
                ++retval;
            }
        }
        return retval;
    }

    public void clear() {
        this.treeData.clear();
        this.nodeStateMap.clear();
    }

    public boolean isEmpty() {
        return this.treeData.isEmpty();
    }

    public void setRootNodes(List<T> rootNodeList) {
        this.treeData.addAll(rootNodeList);
    }

    public void setSelectionModel(TreeModel.SelectionModel selectionModel) {
        this.selectionModel = selectionModel;
        if (selectionModel == TreeModel.SelectionModel.NO_SELECT) {
            this.unselectAll();
        }
    }

    public TreeModel.SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelected(T node, boolean selected) {
        switch (this.selectionModel) {
            case SINGLE_SELECT: {
                this.unselectAll();
            }
            case MULTI_SELECT: {
                this.nodeStateMap.get(node).setSelected(selected);
                ((FacesTreeNode)node).getListRow().setSelected(Boolean.valueOf(selected));
                break;
            }
            case NO_SELECT: {
                if (selected) {
                    throw new IllegalStateException("Current selection model prohibits selection of a node");
                }
                this.nodeStateMap.get(node).setSelected(selected);
                ((FacesTreeNode)node).getListRow().setSelected(Boolean.valueOf(selected));
                break;
            }
        }
    }

    public void setSelected(boolean selected) {
        if (selected && (this.selectionModel == TreeModel.SelectionModel.SINGLE_SELECT || this.selectionModel == TreeModel.SelectionModel.NO_SELECT)) {
            throw new IllegalStateException("Current selection model prohibits selection of a node");
        }
        this.nodeStateMap.setAllSelected(selected);
        for (FacesTreeNode rootNode : this.treeData) {
            Enumeration<TreeNode> e = rootNode.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                FacesTreeNode n = (FacesTreeNode)e.nextElement();
                n.getListRow().setSelected(Boolean.valueOf(selected));
            }
        }
    }

    private void unselectAll() {
        for (FacesTreeNode rootNode : this.treeData) {
            Enumeration<TreeNode> e = rootNode.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                FacesTreeNode n = (FacesTreeNode)e.nextElement();
                n.getListRow().setSelected(Boolean.FALSE);
            }
        }
        this.nodeStateMap.setAllSelected(false);
    }

    public boolean isSelected(T node) {
        return ((FacesTreeNode)node).getListRow().isRowSelected();
    }

    public List<T> getSelected() {
        return this.nodeStateMap.getSelected();
    }

    public void setExpanded(T node, boolean expanded) {
        this.nodeStateMap.get(node).setExpanded(expanded);
    }

    public void setExpanded(boolean expanded) {
        this.nodeStateMap.setAllExpanded(expanded);
    }

    public boolean isExpanded(T node) {
        return this.nodeStateMap.get(node).isExpanded();
    }

    public List<T> getExpanded() {
        return this.nodeStateMap.getExpanded();
    }

    public void setEnabled(boolean enabled) {
        this.setProperty((Property)BooleanProperty.ENABLED, enabled);
    }

    public void setNodeEnabled(T node, boolean enabled) {
        this.setNodeProperty(node, (Property)BooleanProperty.ENABLED, enabled);
    }

    public void setColumnEnabled(DialogObjectConstant columnIdentifier, boolean enabled) {
        this.setColumnProperty(columnIdentifier, (Property)BooleanProperty.ENABLED, enabled);
    }

    public void setCellEnabled(T node, DialogObjectConstant columnIdentifier, boolean enabled) {
        this.setCellProperty(node, columnIdentifier, (Property)BooleanProperty.ENABLED, enabled);
    }

    public boolean isCellEnabled(T node, DialogObjectConstant columnIdentifier) {
        return (Boolean)this.getCellProperty(node, columnIdentifier, (Property)BooleanProperty.ENABLED);
    }

    public void setShown(boolean shown) {
        this.setProperty((Property)BooleanProperty.SHOWN, shown);
    }

    public void setNodeShown(T node, boolean shown) {
        this.setNodeProperty(node, (Property)BooleanProperty.SHOWN, shown);
    }

    public void setColumnShown(DialogObjectConstant columnIdentifier, boolean shown) {
        this.setColumnProperty(columnIdentifier, (Property)BooleanProperty.SHOWN, shown);
    }

    public void setCellShown(T node, DialogObjectConstant columnIdentifier, boolean shown) {
        this.setCellProperty(node, columnIdentifier, (Property)BooleanProperty.SHOWN, shown);
    }

    public boolean isCellShown(T node, DialogObjectConstant columnIdentifier) {
        return (Boolean)this.getCellProperty(node, columnIdentifier, (Property)BooleanProperty.SHOWN);
    }

    public <U> void setProperty(Property<U> property, U propertyValue) {
        for (FacesTreeNode rootNode : this.treeData) {
            Enumeration<TreeNode> e = rootNode.preorderEnumeration();
            while (e.hasMoreElements()) {
                FacesTreeNode node = (FacesTreeNode)e.nextElement();
                this.setNodeProperty((T)node, property, propertyValue);
            }
        }
    }

    public <U> void setNodeProperty(T node, Property<U> property, U propertyValue) {
        Object row = ((FacesTreeNode)node).getListRow();
        for (DialogObjectConstant columnIdentifier : row.getFields()) {
            row.setProperty(columnIdentifier, property, propertyValue);
        }
    }

    public <U> void setColumnProperty(DialogObjectConstant columnIdentifier, Property<U> propertyName, U value) {
        for (FacesTreeNode rootNode : this.treeData) {
            Enumeration<TreeNode> e = rootNode.preorderEnumeration();
            while (e.hasMoreElements()) {
                FacesTreeNode node = (FacesTreeNode)e.nextElement();
                node.getListRow().setProperty(columnIdentifier, propertyName, value);
            }
        }
    }

    public <U> void setCellProperty(T node, DialogObjectConstant columnIdentifier, Property<U> propertyName, U propertyValue) {
        ((FacesTreeNode)node).getListRow().setProperty(columnIdentifier, propertyName, propertyValue);
    }

    public <U> U getCellProperty(T node, DialogObjectConstant columnIdentifier, Property<U> propertyName) {
        return (U)((FacesTreeNode)node).getListRow().getProperty(columnIdentifier, propertyName);
    }

    public void addTreeNodeComparator(DialogObjectConstant nodeConst, TreeNodeComparator comparator) {
        this.comparatorMap.put(nodeConst, comparator);
    }

    public void sortTree(List<T> nodeList) {
        Comparator comparator;
        FacesTreeNode node;
        if (!nodeList.isEmpty() && (node = (FacesTreeNode)nodeList.get(0)).getNodeConst() != null && (comparator = (Comparator)this.comparatorMap.get(node.getNodeConst().getParent())) != null) {
            Collections.sort(nodeList, comparator);
        }
        for (FacesTreeNode rootNode : nodeList) {
            this.sortChildren(rootNode);
        }
    }

    private void sortChildren(T node) {
        Comparator comparator;
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)node).children();
        ArrayList<TreeNode> childNodeList = new ArrayList<TreeNode>();
        while (e.hasMoreElements()) {
            childNodeList.add(e.nextElement());
        }
        ((FacesTreeNode)node).removeAllChildren();
        if (childNodeList.size() != 0 && (comparator = (Comparator)this.comparatorMap.get(((FacesTreeNode)node).getNodeConst())) != null) {
            Collections.sort(childNodeList, comparator);
        }
        for (FacesTreeNode facesTreeNode : childNodeList) {
            this.sortChildren(facesTreeNode);
            ((FacesTreeNode)node).add(facesTreeNode);
        }
    }
}

