/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.view.faces;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

@SuppressWarnings("javadoc")
public class ResponseHeaderFilter implements Filter {

    private String header;
    private String value;

    @Override
    public void init(FilterConfig fc) throws ServletException {
        header = fc.getInitParameter("header");
        value = fc.getInitParameter("value");
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse) res;
        response.setHeader(header, value);
        fc.doFilter(req, res);
    }

    @Override
    public void destroy() {
        // EMPTY
    }

}