/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.view.faces;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.validator.ValidateContext;
import no.g9.message.Message;
import no.g9.support.ResourceProvider;

public class FacesMessageUtil {
    public static final String CONVERSION_ERROR = "converter.conversionError";
    public static final String ILLEGAL_PARAMETER = "converter.illegalParameter";
    private static ResourceProvider<String> externalResourceProvider;

    public static ResourceProvider<String> getExternalResourceProvider() {
        return externalResourceProvider;
    }

    public static void setExternalResourceProvider(ResourceProvider<String> resourceProvider) {
        externalResourceProvider = resourceProvider;
    }

    public static void addContextMessage(UIComponent component, FacesMessage.Severity severity, String key, String title) {
        FacesContext context = FacesContext.getCurrentInstance();
        String summary = FacesMessageUtil.getBundleMessage(key);
        String clientID = null;
        if (component != null) {
            clientID = component.getClientId(context);
        }
        FacesMessage facesMessage = new FacesMessage(severity, summary, title);
        context.addMessage(clientID, facesMessage);
    }

    private static String getCurrentCompClientId(FacesContext context, UIComponent uic, String key) {
        if (uic.getId().equals(key)) {
            return uic.getClientId(context);
        }
        for (UIComponent uiComponent : uic.getChildren()) {
            if (uiComponent.getId().equals(key)) {
                return uiComponent.getClientId(context);
            }
            String tmp = FacesMessageUtil.getCurrentCompClientId(context, uiComponent, key);
            if (tmp == null) continue;
            return tmp;
        }
        return null;
    }

    public static void addContextMessage(Message message) {
        FacesContext context = FacesContext.getCurrentInstance();
        String detail = message.getMessageText();
        String summary = message.getTitle();
        ValidateContext con = (ValidateContext)message.getContext();
        String clientId = null;
        if (con != null) {
            String internalName = con.getDialogObjectConstant().getInternalName();
            clientId = FacesMessageUtil.getCurrentCompClientId(context, (UIComponent)context.getViewRoot(), internalName);
        }
        FacesMessage facesMessage = new FacesMessage(summary, detail);
        context.addMessage(clientId, facesMessage);
    }

    public static boolean hasContextMessages() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            return false;
        }
        return null != context.getMaximumSeverity();
    }

    public static boolean hasContextMessages(DialogObjectConstant target) {
        return !FacesMessageUtil.getContextMessages(target).isEmpty();
    }

    public static List getContextMessages(DialogObjectConstant target) {
        LinkedList<String> messages = new LinkedList<String>();
        String clientId = null;
        if (target != null) {
            clientId = FacesMessageUtil.getClientId(target);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Iterator msgIter = context.getMessages(clientId);
        while (msgIter.hasNext()) {
            FacesMessage msg = (FacesMessage)msgIter.next();
            messages.add(msg.getSummary());
        }
        return messages;
    }

    private static String getClientId(DialogObjectConstant target) {
        return "iceform:" + target.getInternalName();
    }

    public static void clearContextMessages() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            return;
        }
        Iterator messages = context.getMessages();
        while (messages.hasNext()) {
            messages.next();
            messages.remove();
        }
    }

    public static String getBundleMessage(String key) {
        return FacesMessageUtil.getBundleMessage(null, key);
    }

    public static String getBundleMessage(String bundleName, String key) {
        Locale locale = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            if (bundleName == null) {
                bundleName = context.getApplication().getMessageBundle();
            }
            locale = context.getViewRoot().getLocale();
        }
        return FacesMessageUtil.getBundleMessage(bundleName, key, locale);
    }

    public static String getBundleMessage(String bundleName, String key, Locale locale) {
        String text = FacesMessageUtil.getExternalResource(bundleName, key, locale);
        if (text != null) {
            return text;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, FacesMessageUtil.getCurrentClassLoader(key));
        try {
            text = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            text = "???" + key + "???";
        }
        return text;
    }

    private static ClassLoader getCurrentClassLoader(Object defaultObject) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = defaultObject.getClass().getClassLoader();
        }
        return loader;
    }

    private static String getExternalResource(String bundleName, String key, Locale locale) {
        if (externalResourceProvider == null) {
            return null;
        }
        return (String)externalResourceProvider.getResource(bundleName, key, locale);
    }
}

