/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.view.faces;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.MethodExpressionActionListener;
import javax.servlet.http.Cookie;
import no.esito.jvine.controller.DialogInstanceKey;
import no.esito.jvine.view.faces.ApplicationInfo;
import no.esito.jvine.view.faces.FacesMessageUtil;
import no.esito.log.Logger;
import no.g9.client.core.communication.SystemMessage;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogInstance;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.faces.FacesApplicationView;
import no.g9.client.core.view.faces.FacesDialogView;
import no.g9.client.core.view.faces.FacesMenuItem;
import no.g9.client.core.view.menu.Menu;
import no.g9.client.core.view.menu.MenuBase;
import no.g9.client.core.view.menu.MenuItem;
import no.g9.exception.G9BaseException;
import org.icefaces.ace.component.ajax.AjaxBehavior;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.util.StringUtils;

public class MenuHelper {
    public static final String TITLE_KEY = "title";
    public static final String MNEMONIC_KEY = "mnemonic";
    public static final String ACCELERATOR_KEY = "accelerator";
    public static final String DIALOG_PREFIX = "dialog";
    private static Logger logger = Logger.getLogger(MenuHelper.class);

    public static String getStyleClass(MenuBase menuBase) {
        return menuBase.getStyle();
    }

    public static String getMenuIconClass(MenuBase menuBase, FacesDialogView view) {
        if (menuBase == null || menuBase.getImage() == null && menuBase.getDisabledImage() == null) {
            return null;
        }
        String imgExpr = menuBase.getImage().getName();
        if (!view.isEnabled(view.getDialogObjectFromName(menuBase.getId())) && menuBase.getDisabledImage() != null) {
            imgExpr = menuBase.getDisabledImage().getName();
        }
        return "gvaMenuImage " + imgExpr;
    }

    public static void addActionListeners(FacesMenuItem facesItem, MenuItem item, FacesDialogView view) {
        for (String event : item.getMethods().keySet()) {
            facesItem.addActionListener(MenuHelper.createActionListener(MenuHelper.getActionExpression(event, item, view)));
        }
    }

    public static void addAjaxBehaviorTo(FacesMenuItem menuItem) {
        AjaxBehavior ajaxBehavior = new AjaxBehavior();
        ajaxBehavior.setExecute("@form");
        ajaxBehavior.setRender("@form");
        menuItem.addClientBehavior("action", (ClientBehavior)ajaxBehavior);
    }

    public static SystemMessage getExternalMessage(MenuItem item) {
        SystemMessage message = null;
        for (String event : item.getMethods().keySet()) {
            for (String method : (List)item.getMethods().get(event)) {
                message = new SystemMessage(item.getApplicationId(), "_application_menu", method);
            }
        }
        return message;
    }

    public static ActionListener createActionListener(String actionExpression) {
        FacesContext context = FacesContext.getCurrentInstance();
        MethodExpression methodExpression = context.getApplication().getExpressionFactory().createMethodExpression(context.getELContext(), actionExpression, null, new Class[]{ActionEvent.class});
        return new MethodExpressionActionListener(methodExpression);
    }

    public static Menu.MENU_TYPE getInsertPoint(List<Menu> menus) {
        for (Menu menu : menus) {
            switch (menu.getType()) {
                case WINDOWMENU: {
                    return Menu.MENU_TYPE.WINDOWMENU;
                }
                case HELPMENU: {
                    return Menu.MENU_TYPE.HELPMENU;
                }
            }
        }
        return null;
    }

    private static String getActionExpression(String event, MenuItem item, FacesDialogView view) {
        String methodRef = StringUtils.uncapitalize((String)item.getId()) + "_" + event;
        return "#{" + view.createBeanRef() + "." + methodRef + "}";
    }

    public static String getTitle(DialogObjectConstant item, DialogConstant dialog, String bundleName) {
        String key = MenuHelper.getBundleKey(item, dialog, TITLE_KEY);
        return FacesMessageUtil.getBundleMessage(bundleName, key);
    }

    public static String getMnemonic(DialogObjectConstant item, DialogConstant dialog, String bundleName) {
        String key = MenuHelper.getBundleKey(item, dialog, MNEMONIC_KEY);
        return FacesMessageUtil.getBundleMessage(bundleName, key);
    }

    public static String getAccelerator(DialogObjectConstant item, DialogConstant dialog, String bundleName) {
        String key = MenuHelper.getBundleKey(item, dialog, ACCELERATOR_KEY);
        return FacesMessageUtil.getBundleMessage(bundleName, key);
    }

    public static String getBundleKey(DialogObjectConstant item, DialogConstant dialog, String suffix) {
        return "dialog." + dialog.getG9Name() + "." + item.getG9Name() + "." + suffix;
    }

    public static FacesDialogView getDialogView(MenuBase item, FacesApplicationView appView) {
        try {
            DialogConstant dialog = appView.getApplicationController().getDialogConst(item.getDialogId());
            DialogInstanceKey instance = new DialogInstanceKey(dialog, MenuHelper.getDialogInstance(item));
            return (FacesDialogView)appView.getDialogView((DialogInstance)instance);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public static List<Menu> getApplicationMenus(ApplicationInfo applicationInfo) {
        try {
            String applicationUrl = applicationInfo.url;
            InputStream response = new URL(MenuHelper.getMenuResourceUrl(applicationUrl)).openStream();
            if (response == null) {
                throw new G9BaseException("No response from " + applicationUrl);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Response from " + applicationUrl + ", available bytes: " + response.available()));
            }
            List<Menu> menus = MenuHelper.parseMenuResponse(response);
            response.close();
            MenuHelper.tagApplicationId(menus, applicationInfo.name);
            return menus;
        }
        catch (IOException e) {
            throw new G9BaseException("IOException for application " + applicationInfo, (Throwable)e);
        }
    }

    public static String getSetupUrl() {
        Cookie setupCookie = (Cookie)FacesContext.getCurrentInstance().getExternalContext().getRequestCookieMap().get("setupUrl");
        if (setupCookie != null) {
            return setupCookie.getValue();
        }
        throw new G9BaseException("G9 exeption. Missing system setup");
    }

    public static Menu createApplicationMenu(String applicationName, String applicationTitle, DialogConstant dialog) {
        String applicationId = applicationName.replace(' ', '_');
        Menu appMenu = new Menu(applicationId, dialog.getInternalName(), applicationTitle, null, null, null, null, null, Menu.MENU_TYPE.USERMENU);
        return appMenu;
    }

    public static Map<String, ApplicationInfo> getApplications(String setupUrl) {
        LinkedHashMap<String, ApplicationInfo> apps = new LinkedHashMap<String, ApplicationInfo>();
        List<String> applicationUrls = MenuHelper.getApplicationUrls(setupUrl);
        for (String url : applicationUrls) {
            ApplicationInfo info = null;
            try {
                info = MenuHelper.getApplicationInfo(url);
            }
            catch (G9BaseException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                info = new ApplicationInfo(url);
            }
            apps.put(info.name, info);
        }
        return apps;
    }

    private static ApplicationInfo getApplicationInfo(String applicationUrl) {
        try {
            String url;
            InputStream response;
            if (!applicationUrl.endsWith("/")) {
                applicationUrl = applicationUrl + "/";
            }
            if ((response = new URL(url = applicationUrl + "resources/application.json").openStream()) == null) {
                throw new G9BaseException("No response from " + url);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Response from " + url + ", available bytes: " + response.available()));
            }
            ApplicationInfo info = MenuHelper.parseApplicationResponse(response, applicationUrl);
            response.close();
            return info;
        }
        catch (IOException e) {
            throw new G9BaseException("IOException for setup " + applicationUrl, (Throwable)e);
        }
    }

    private static List<String> getApplicationUrls(String setupUrl) {
        try {
            InputStream response = new URL(setupUrl).openStream();
            if (response == null) {
                throw new G9BaseException("No response from " + setupUrl);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Response from " + setupUrl + ", available bytes: " + response.available()));
            }
            List<String> applications = MenuHelper.parseSetupResponse(response);
            response.close();
            return applications;
        }
        catch (IOException e) {
            throw new G9BaseException("IOException for setup " + setupUrl, (Throwable)e);
        }
    }

    private static List<Menu> parseMenuResponse(InputStream response) {
        try {
            ObjectInputStream ois = new ObjectInputStream(response);
            Object o = ois.readObject();
            return (List)o;
        }
        catch (IOException e) {
            throw new G9BaseException("IOException when reading application menu objects", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new G9BaseException("Exception when parsing application menu objects", (Throwable)e);
        }
    }

    private static List<String> parseSetupResponse(InputStream response) {
        try {
            ArrayList<String> urls = new ArrayList<String>();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode tree = mapper.readTree(response);
            Iterator partsIterator = tree.findValue("parts").elements();
            while (partsIterator.hasNext()) {
                JsonNode part = (JsonNode)partsIterator.next();
                if (part.findValue("external") != null) continue;
                urls.add(part.findValue("url").asText());
            }
            return urls;
        }
        catch (IOException e) {
            throw new G9BaseException("IOException when reading application menu objects", (Throwable)e);
        }
    }

    private static ApplicationInfo parseApplicationResponse(InputStream response, String applicationUrl) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode tree = mapper.readTree(response);
            ApplicationInfo info = new ApplicationInfo(tree.findValue("name").asText(), tree.findValue(TITLE_KEY).asText(), applicationUrl);
            return info;
        }
        catch (IOException e) {
            throw new G9BaseException("IOException when reading application menu objects", (Throwable)e);
        }
    }

    private static String getMenuResourceUrl(String applicationUrl) {
        if (!applicationUrl.endsWith("/")) {
            applicationUrl = applicationUrl + "/";
        }
        return applicationUrl + "gva-resource" + "?" + "type" + "=" + "application-menu";
    }

    private static int getDialogInstance(MenuBase item) {
        Menu parent = item instanceof Menu ? (Menu)item : item.getParent();
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent.getDialogInstance();
    }

    private static void tagApplicationId(List<Menu> menus, String applicationId) {
        for (Menu menu : menus) {
            MenuHelper.tagApplicationId(menu, applicationId);
        }
    }

    private static void tagApplicationId(Menu menu, String applicationId) {
        for (MenuBase item : menu.getChildren()) {
            if (item instanceof MenuItem) {
                item.setApplicationId(applicationId);
                continue;
            }
            if (!(item instanceof Menu)) continue;
            MenuHelper.tagApplicationId((Menu)item, applicationId);
        }
    }
}

