/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import no.esito.jvine.view.faces.FacesMessageUtil;
import no.g9.client.core.controller.DialogInstance;
import no.g9.client.core.view.faces.FacesApplicationView;
import no.g9.message.Message;
import no.g9.message.MessageReplyType;
import no.g9.message.MessageTypeEnum;
import no.g9.message.ReplySetType;
import no.g9.support.ResourceProvider;
import org.icefaces.ace.event.CloseEvent;

public abstract class FacesApplicationBean {
    private FacesApplicationView applicationView;
    private String messageInput;
    private static String applicationBeanName = null;

    public FacesApplicationBean(String applicationBeanName, FacesApplicationView applicationView) {
        this.setApplicationBeanName(applicationBeanName);
        this.setApplicationView(applicationView);
        applicationView.setApplicationBean(this);
    }

    protected FacesApplicationBean() {
    }

    private synchronized void setApplicationBeanName(String name) {
        applicationBeanName = name;
    }

    public FacesApplicationView getApplicationView() {
        return this.applicationView;
    }

    public void setApplicationView(FacesApplicationView applicationView) {
        this.applicationView = applicationView;
    }

    public String getFacesMessage(String bundleName, String key) {
        return FacesMessageUtil.getBundleMessage(bundleName, key);
    }

    public String msg(String key) {
        return this.getFacesMessage(null, key);
    }

    public String getDialogIncludePath() {
        return this.buildDialogIncludePath();
    }

    public int getNumberOfOpenDialogBoxes() {
        return this.getApplicationView().getOpenDialogBoxes().size();
    }

    public String[] getDialogBoxIncludePaths() {
        return this.buildDialogBoxIncludePaths();
    }

    protected String getDialogToolbarIncludePath() {
        return this.buildDialogToolbarIncludePath();
    }

    protected abstract String buildDialogIncludePath();

    protected abstract String[] buildDialogBoxIncludePaths();

    protected abstract String buildDialogToolbarIncludePath();

    public void messageBox_CloseClicked(CloseEvent event) {
        this.getApplicationView().handleMessageReply(MessageReplyType.REPLY_CANCEL);
    }

    public void messageBox_OkClicked(ActionEvent event) {
        this.getApplicationView().handleMessageReply(MessageReplyType.REPLY_OK);
    }

    public void messageBox_YesClicked(ActionEvent event) {
        this.getApplicationView().handleMessageReply(MessageReplyType.REPLY_YES);
    }

    public void messageBox_NoClicked(ActionEvent event) {
        this.getApplicationView().handleMessageReply(MessageReplyType.REPLY_NO);
    }

    public void messageBox_CancelClicked(ActionEvent event) {
        this.getApplicationView().handleMessageReply(MessageReplyType.REPLY_CANCEL);
    }

    public void messageBox_AbortClicked(ActionEvent event) {
        this.getApplicationView().handleMessageReply(MessageReplyType.REPLY_ABORT);
    }

    public void messageBox_RetryClicked(ActionEvent event) {
        this.getApplicationView().handleMessageReply(MessageReplyType.REPLY_RETRY);
    }

    public void messageBox_IgnoreClicked(ActionEvent event) {
        this.getApplicationView().handleMessageReply(MessageReplyType.REPLY_IGNORE);
    }

    public boolean getShowMessage() {
        return this.getApplicationView().getShowMessage();
    }

    public void setShowMessage(boolean on) {
    }

    public String getMessageBoxTitle() {
        String appName = this.getApplicationView().getApplicationController().getApplicationName();
        String title = this.getFacesMessage(null, appName.toLowerCase() + ".title");
        if (this.getShowMessage() && !Message.isEmpty((String)this.getApplicationView().getMessage().getTitle())) {
            title = this.getApplicationView().getMessage().getTitle();
        }
        return title;
    }

    public String getMessageBoxIcon() {
        String appName = this.getApplicationView().getApplicationController().getApplicationName();
        MessageTypeEnum type = MessageTypeEnum.NONE;
        if (this.getShowMessage()) {
            type = this.getApplicationView().getMessage().getMsgType();
        }
        return this.getFacesMessage(null, appName.toLowerCase() + "." + type + ".image");
    }

    public String getMessageBoxAltText() {
        String appName = this.getApplicationView().getApplicationController().getApplicationName();
        MessageTypeEnum type = MessageTypeEnum.NONE;
        if (this.getShowMessage()) {
            type = this.getApplicationView().getMessage().getMsgType();
        }
        return this.getFacesMessage(null, appName.toLowerCase() + "." + type + ".alt");
    }

    public String getMessageText() {
        if (this.getShowMessage()) {
            return this.getApplicationView().getMessage().getMessageText();
        }
        return null;
    }

    public boolean getShowMessageInput() {
        return this.getShowMessage() && ReplySetType.REPLSET_STRING.equals((Object)this.getApplicationView().getMessage().getValidReplies());
    }

    public boolean getShowMessageOkButton() {
        return this.showMessageReply(MessageReplyType.REPLY_OK);
    }

    public boolean getShowMessageYesButton() {
        return this.showMessageReply(MessageReplyType.REPLY_YES);
    }

    public boolean getShowMessageNoButton() {
        return this.showMessageReply(MessageReplyType.REPLY_NO);
    }

    public boolean getShowMessageCancelButton() {
        return this.showMessageReply(MessageReplyType.REPLY_CANCEL);
    }

    public boolean getShowMessageAbortButton() {
        return this.showMessageReply(MessageReplyType.REPLY_ABORT);
    }

    public boolean getShowMessageRetryButton() {
        return this.showMessageReply(MessageReplyType.REPLY_RETRY);
    }

    public boolean getShowMessageIgnoreButton() {
        return this.showMessageReply(MessageReplyType.REPLY_IGNORE);
    }

    private boolean showMessageReply(MessageReplyType reply) {
        if (this.getShowMessage()) {
            MessageReplyType[] validReplies;
            for (MessageReplyType r : validReplies = this.getApplicationView().getMessage().getValidReplies().toReplySet()) {
                if (r != reply) continue;
                return true;
            }
        }
        return false;
    }

    public String getMessageInput() {
        return this.messageInput;
    }

    public void setMessageInput(String messageInput) {
        this.messageInput = messageInput;
    }

    public String getMessageBoxFocusButton() {
        MessageReplyType[] validReplies;
        MessageReplyType defaultReply = MessageReplyType.REPLY_OK;
        if (this.getShowMessage() && (validReplies = this.getApplicationView().getMessage().getValidReplies().toReplySet()).length > 0) {
            defaultReply = validReplies[0];
        }
        return this.getMessageBoxButtonId(defaultReply);
    }

    protected String getMessageBoxButtonId(MessageReplyType reply) {
        String PREFIX = "messageBox_";
        if (reply == MessageReplyType.REPLY_ABORT) {
            return "messageBox_abort";
        }
        if (reply == MessageReplyType.REPLY_CANCEL) {
            return "messageBox_cancel";
        }
        if (reply == MessageReplyType.REPLY_IGNORE) {
            return "messageBox_ignore";
        }
        if (reply == MessageReplyType.REPLY_NO) {
            return "messageBox_no";
        }
        if (reply == MessageReplyType.REPLY_RETRY) {
            return "messageBox_retry";
        }
        if (reply == MessageReplyType.REPLY_YES) {
            return "messageBox_yes";
        }
        return "messageBox_ok";
    }

    public String getDialogTitle(DialogInstance instance) {
        return this.getApplicationView().getDialogTitle(instance);
    }

    public static <T> T getFacesBean(String beanName) {
        FacesContext context = FacesContext.getCurrentInstance();
        return (T)context.getApplication().evaluateExpressionGet(context, "#{" + beanName + "}", Object.class);
    }

    public static FacesApplicationBean getCurrentApplicationBean() {
        String beanName = applicationBeanName;
        if (beanName == null) {
            throw new IllegalStateException("");
        }
        FacesApplicationBean bean = (FacesApplicationBean)FacesApplicationBean.getFacesBean(beanName);
        return bean;
    }

    public static void setExternalResourceProvider(ResourceProvider<String> resourceProvider) {
        FacesMessageUtil.setExternalResourceProvider(resourceProvider);
    }
}

