/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import java.text.ParseException;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import no.esito.log.Logger;
import no.esito.util.NumberFormat;
import no.g9.client.core.view.faces.ConverterHelper;
import no.g9.client.core.view.faces.G9Converter;
import no.g9.support.FormatHelper;
import no.g9.support.G9Consts;
import no.g9.support.Numeric;

public class NumberConverter
implements Converter,
G9Converter,
PartialStateHolder {
    private static final Logger log = Logger.getLogger(NumberConverter.class);
    private Integer inputLength;
    private Integer storedLength;
    private Integer scale;
    private Boolean blankWhenZero;
    private NumberFormat numberFormat = null;
    private ConverterHelper converterHelper = new ConverterHelper();
    private Boolean isG9Numeric = false;
    private boolean transientFlag = false;
    private boolean initialState;

    public NumberConverter() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created instance: " + this));
        }
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        Object retVal = null;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("getAsObject: " + this + ", component: " + component.getId() + ", value: " + value));
        }
        if (this.isOverflow(value)) {
            retVal = this.converterHelper.getComponentValue(component);
            if (log.isTraceEnabled()) {
                log.trace((Object)("getAsString: " + this + ", component: " + component.getId() + ", restore overflow value: " + retVal));
            }
            return retVal;
        }
        if (value != null) {
            if (value.trim().length() < 1) {
                return null;
            }
            try {
                retVal = this.getNumberFormat().parse(value, false);
                if (retVal instanceof Numeric && !this.isG9Numeric.booleanValue()) {
                    retVal = ((Numeric)retVal).getValue();
                }
            }
            catch (ParseException e) {
                throw new ConverterException(this.converterHelper.getConversionErrorMessage());
            }
        }
        return retVal;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("getAsString: " + this + ", component: " + component.getId() + ", value: " + value));
        }
        if (value == null) {
            return "";
        }
        return this.getOutputText(value);
    }

    private String getOutputText(Object value) {
        String strValue = null;
        if (value != null) {
            strValue = this.isBlankWhenZero() && NumberFormat.isZero((Object)value) ? "" : this.getNumberFormat().format(FormatHelper.getNumericFormat((String)this.getDisplayRule()), value, false);
        }
        return strValue;
    }

    private int getDataTypeAsInt() {
        return G9Consts.Converter.fromName((String)this.getDataType());
    }

    private NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = new NumberFormat(this.getDataTypeAsInt(), this.getDisplayRule());
        }
        return this.numberFormat;
    }

    private boolean isOverflow(String value) {
        return value != null && value.matches("#*");
    }

    @Override
    public String getDataType() {
        return this.converterHelper.getDataType();
    }

    @Override
    public void setDataType(String dataType) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("setDataType: " + this + ", dataType: " + dataType));
        }
        this.clearInitialState();
        this.converterHelper.setDataType(dataType);
        if (this.numberFormat != null) {
            this.numberFormat = new NumberFormat(this.getDataTypeAsInt(), this.getDisplayRule());
        }
    }

    @Override
    public String getDisplayRule() {
        return FormatHelper.getDisplayrule((int)this.getDataTypeAsInt(), (String)this.converterHelper.getDisplayRule(), (int)this.getInputLength(), (int)this.getStoredLength(), (int)this.getScale());
    }

    @Override
    public void setDisplayRule(String displayRule) {
        this.clearInitialState();
        this.converterHelper.setDisplayRule(displayRule);
        if (this.numberFormat != null) {
            this.numberFormat = new NumberFormat(this.getDataTypeAsInt(), this.getDisplayRule());
        }
    }

    public int getInputLength() {
        return this.inputLength;
    }

    public void setInputLength(int inputLength) {
        this.clearInitialState();
        this.inputLength = inputLength;
    }

    public int getStoredLength() {
        return this.storedLength;
    }

    public void setStoredLength(int storedLength) {
        this.clearInitialState();
        this.storedLength = storedLength;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.clearInitialState();
        this.scale = scale;
    }

    public boolean isBlankWhenZero() {
        return this.blankWhenZero;
    }

    public void setBlankWhenZero(boolean blankWhenZero) {
        this.clearInitialState();
        this.blankWhenZero = blankWhenZero;
    }

    public Boolean getIsG9Numeric() {
        return this.isG9Numeric;
    }

    public void setIsG9Numeric(Boolean isG9Numeric) {
        this.isG9Numeric = isG9Numeric;
    }

    @Override
    public String getTitle() {
        return this.converterHelper.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.clearInitialState();
        this.converterHelper.setTitle(title);
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.initialStateMarked()) {
            Object[] values = new Object[7];
            values[0] = this.inputLength;
            values[1] = this.storedLength;
            values[2] = this.scale;
            values[3] = this.blankWhenZero;
            values[4] = this.numberFormat;
            values[5] = this.converterHelper;
            values[5] = this.isG9Numeric;
            return values;
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            Object[] values = (Object[])state;
            this.inputLength = (Integer)values[0];
            this.storedLength = (Integer)values[1];
            this.scale = (Integer)values[2];
            this.blankWhenZero = (Boolean)values[3];
            this.numberFormat = (NumberFormat)values[4];
            this.converterHelper = (ConverterHelper)values[5];
            this.isG9Numeric = (Boolean)values[6];
        }
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    public void markInitialState() {
        this.initialState = true;
    }

    public boolean initialStateMarked() {
        return this.initialState;
    }

    public void clearInitialState() {
        this.initialState = false;
    }
}

