/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.view.faces;

import no.g9.client.core.view.faces.FacesApplicationView;

/**
 * Struct for holding some application info.
 * Used by the MenuHelper class.
 */
public final class ApplicationInfo {

    /** The application name */
    public final String name;

    /** The application title */
    public final String title;

    /** The application URL */
    public final String url;

    /**
     * Create a new info struct.
     *
     * @param name the application name
     * @param title  the application title
     * @param url  the application URL
     */
    public ApplicationInfo(String name, String title, String url) {
        this.name = name;
        this.title = title;
        this.url = url;
    }

    /**
     * Create a new info struct for an application which is not available.
     *
     * @param url  the application URL
     */
    public ApplicationInfo(String url) {
        this.name = url.replace(" ", "_").replace(":", "_").replace("/", "_").replace(".", "_");
        this.title = FacesApplicationView.NOT_AVAILABLE_PREFIX + ": " + url;
        this.url = url;
    }

    @Override
    public String toString() {
        return name;
    }
}
