/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.util;

import java.util.List;

import javax.faces.model.SelectItem;

import no.g9.client.core.controller.DialogController;


/**
 * A provider of autocomplete search results.
 */
public interface AutoCompleteProvider {

	/**
	 * Update the result list with search results from the given search term.
	 *
	 * @param searchTerm the search term to use
	 * @param resultList the result list to update
	 * @param config the autocomplete configuration to use for the search
	 * @param controller the dialog controller using the provider
	 */
	void updateResultList(Object searchTerm, List<SelectItem> resultList, AutoCompleteConfig config, DialogController controller);

}
