/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view.faces;

/**
 * Enum for the supported ICEfaces CSS themes.
 *
 */
public enum CssTheme {

    /**
     * The Rime theme.
     */
    RIME("rime"),

    /**
     * The Sam theme.
     */
    SAM("sam");

    private static final String RESOURCE_PATH = "./xmlhttp/css";
    private static final String LIBRARY = "org.icefaces.component.skins";
    private static final String IMAGE_DIR = "css-images";
    private static final String CSS_EXT = ".css";
    private static final String SKIN_PREFIX = "ice-skin-";

    private final String name;

    private CssTheme(String name) {
        this.name = name;
    }

    /**
     * @return the style class for this theme
     */
    public String getStyleClass() {
        return CssTheme.SKIN_PREFIX + name;
    }

    /**
     * @return the css file for this theme
     */
    public String getFile() {
        return name + CssTheme.CSS_EXT;
    }

    /**
     * @return the resource library
     */
    public String getLibrary() {
        return CssTheme.LIBRARY;
    }

    /**
     * @return the path to the image directory
     */
    public String getImageDirectory() {
        return getStylesheetPath() + CssTheme.IMAGE_DIR + "/";
    }

    /**
     * @return the full path to the ice-compat version of the stylesheet
     */
    public String getCompatPath() {
        return getStylesheetPath() + getFile();
    }

    private String getStylesheetPath() {
        return CssTheme.RESOURCE_PATH + "/" + name + "/";
    }

}
