/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view.faces;

import java.util.TimeZone;

import javax.faces.convert.DateTimeConverter;

/**
 * Avoid the bug in the default JSF DateTimeConverter which uses the GMT time
 * zone as default.
 */
public class CustomDateTimeConverter extends DateTimeConverter {

    /**
     * Create a new converter which uses the system default time zone.
     */
    public CustomDateTimeConverter() {
        super();
        setTimeZone(TimeZone.getDefault());
    }

}
