/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view.faces;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import no.esito.log.Logger;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.util.MessageTextHelper;
import no.g9.client.core.view.DialogView;

/**
 * @author maw
 */
public final class FacesTitleMap implements Map<Object, String> {

    private static final Logger log = Logger.getLogger(FacesTitleMap.class);

    private Map<String, String> titleMap = new HashMap<String, String>();
    private Map<String, DialogObjectConstant> enumMap = new HashMap<String, DialogObjectConstant>();

    /**
     * @param enumType type
     * @param dialogView view
     */
    public FacesTitleMap(Class<Enum<?>> enumType, DialogView dialogView) {

        Enum<?>[] enumConstants = enumType.getEnumConstants();
        for (Enum<?> enum1 : enumConstants) {
            if (enum1 instanceof DialogObjectConstant) {
                DialogObjectConstant tmp = (DialogObjectConstant) enum1;
                enumMap.put(tmp.getInternalName(), tmp);
                String title = MessageTextHelper.getLabelTextForField(dialogView, tmp).toString();
                titleMap.put(tmp.getInternalName(), title);
            }
        }
    }

    @Override
    public String get(Object key) {
        String internalName = (String) key;
        String title = titleMap.get(internalName);
        log.trace("Get faces title for " + key +": " + title);
        return title;
    }

    @Override
    public String put(Object key, String value) {
        String oldVal = get(key);
        String internalName = (String)key;
        titleMap.put(internalName, value);
        return oldVal;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }


    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Object> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<java.util.Map.Entry<Object, String>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends String> m) {
        throw new UnsupportedOperationException();
    }

}
