/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view.faces.tree;

import java.io.Serializable;
import java.util.Observable;

/**
 * An observable class that is attached to each tree node to be able to notify 
 * subscribing classes about changes to nodes. 
 *
 */
@SuppressWarnings("serial")
public class NodeObservable extends Observable implements Serializable {

	@Override
	public void notifyObservers() {
		notifyObservers(null);
	}

	@Override
	public void notifyObservers(Object arg) {
		super.setChanged();
		super.notifyObservers(arg);
	}
}
