/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.util;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.faces.model.SelectItem;
import no.esito.util.DateUtil;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.util.AutoCompleteComparator;
import no.g9.client.core.util.AutoCompleteConfig;
import no.g9.client.core.util.AutoCompleteProvider;
import no.g9.client.core.util.QueryBuilder;
import no.g9.client.core.util.RoleNameHelper;
import no.g9.service.JGrapeService;
import no.g9.support.ClientContext;
import no.g9.support.EFindMethod;
import no.g9.support.FindData;

public final class AutoCompleteHelper
implements AutoCompleteProvider {
    @Override
    public void updateResultList(Object searchTerm, List<SelectItem> resultList, AutoCompleteConfig config, DialogController controller) {
        resultList.clear();
        String value = searchTerm != null ? searchTerm.toString() : "";
        String labelColumn = config.getWidget().getAttribute().toString();
        Object[] queryAndValues = QueryBuilder.buildAutoCompleteQueryWithParameters((String)labelColumn, config.getResultColumns(), (String)value, (DialogController)controller);
        Object result = AutoCompleteHelper.getResultForQueryWithParameters(queryAndValues, config.getMaxResults(), controller);
        List<Object[]> objArrList = AutoCompleteHelper.getObjectArrayList(result);
        AutoCompleteHelper.formatDateResults(objArrList, labelColumn, config.getResultColumns(), controller);
        AutoCompleteHelper.convertTypesToString(objArrList, labelColumn, config.getResultColumns(), controller);
        AutoCompleteHelper.updateDisplayList(objArrList, resultList, config.getMaxResults(), 0);
    }

    private static void convertTypesToString(List<Object[]> objArrList, String valueAttribute, List<String> columnAttributes, DialogController controller) {
        RoleNameHelper roleNameHelper = new RoleNameHelper(controller);
        List colNamesAndDataTypes = QueryBuilder.getColumnNamesAndDataTypes((String)valueAttribute, columnAttributes, (RoleNameHelper)roleNameHelper);
        int objIndex = 0;
        for (Object[] objects : colNamesAndDataTypes) {
            String type = String.valueOf(objects[1]);
            if (Strings.isNullOrEmpty((String)type)) continue;
            if (type.equals(Integer.class.getCanonicalName()) || type.equals(Long.class.getCanonicalName())) {
                for (Object[] object : objArrList) {
                    object[objIndex] = String.valueOf(object[objIndex]);
                }
            }
            ++objIndex;
        }
    }

    private static void formatDateResults(List<Object[]> objArrList, String valueAttribute, List<String> columnAttributes, DialogController controller) {
        RoleNameHelper roleNameHelper = new RoleNameHelper(controller);
        List colNamesAndDataTypes = QueryBuilder.getColumnNamesAndDataTypes((String)valueAttribute, columnAttributes, (RoleNameHelper)roleNameHelper);
        int i = 0;
        String displayRule = "";
        for (Object[] resultArray : colNamesAndDataTypes) {
            if (!displayRule.equals("")) continue;
            if (resultArray[1].equals("java.util.Date")) {
                displayRule = resultArray[2].toString();
            }
            ++i;
        }
        for (Object[] object : objArrList) {
            if (displayRule.equals("") || object[i - 1] == null) continue;
            String dateStr = DateUtil.dateToString((Date)((Date)object[i - 1]), (String)displayRule);
            object[i - 1] = dateStr;
        }
    }

    private static void updateDisplayList(List<Object[]> localObjList, List<SelectItem> displayList, int noOfRows, int valueDisplayPosition) {
        displayList.clear();
        for (Object[] objectVar : localObjList) {
            if (noOfRows > 0 && displayList.size() >= noOfRows) break;
            String title = objectVar[valueDisplayPosition] != null ? objectVar[valueDisplayPosition].toString() : "";
            SelectItem selectItem = new SelectItem((Object)objectVar, title);
            displayList.add(selectItem);
        }
    }

    private static List<Object[]> getObjectArrayList(Object result) {
        List<Object> objArrList = new ArrayList<Object[]>();
        List localList = (List)result;
        for (Object obj : localList) {
            if (obj instanceof Object[]) {
                objArrList = (List)result;
                continue;
            }
            Object[] val = new Object[]{obj};
            objArrList.add(val);
        }
        Collections.sort(objArrList, new AutoCompleteComparator());
        return objArrList;
    }

    private static Object getResultForQueryWithParameters(Object[] queryAndValues, int noOfRows, DialogController controller) {
        FindData findData = new FindData();
        findData.setFindMethod(EFindMethod.QUERY);
        findData.setQuery((String)queryAndValues[0]);
        findData.setQueryParameters((List)queryAndValues[1]);
        findData.setMaxResults(noOfRows);
        ApplicationController applicationController = controller.getApplicationController();
        JGrapeService serviceProxy = applicationController.getServiceProxy();
        ClientContext ctx = applicationController.getClientContext();
        List result = serviceProxy.findAll(findData, ctx, null);
        return result;
    }
}

