/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import no.esito.jvine.view.ViewModelImpl;
import no.esito.jvine.view.faces.FacesMessageUtil;
import no.g9.client.core.controller.DialogInstance;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.faces.FacesApplicationBean;
import no.g9.client.core.view.faces.FacesApplicationView;
import no.g9.client.core.view.faces.FacesDialogView;
import no.g9.client.core.view.faces.G9Converter;
import no.g9.message.Message;
import no.g9.message.MessageSystem;

public class ConverterHelper
implements G9Converter {
    private String dataType;
    private String displayRule;
    private String title;

    @Override
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDisplayRule(String displayRule) {
        this.displayRule = displayRule;
    }

    @Override
    public String getDisplayRule() {
        return this.displayRule;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    void addConversionErrorMessage(UIComponent component) {
        FacesMessageUtil.addContextMessage(component, FacesMessage.SEVERITY_ERROR, "converter.conversionError", " " + this.getTitle());
    }

    void addIllegalParameterMessage(UIComponent component) {
        FacesMessageUtil.addContextMessage(component, FacesMessage.SEVERITY_FATAL, "converter.illegalParameter", " " + this.getTitle());
    }

    FacesMessage getConversionErrorMessage() {
        return ConverterHelper.getConversionErrorMessage(this.getTitle());
    }

    public static FacesMessage getConversionErrorMessage(String title) {
        Message message = MessageSystem.getMessageFactory().getMessage("-1534", new Object[]{title});
        return new FacesMessage(FacesMessage.SEVERITY_ERROR, message.getTitle(), message.getMessageText());
    }

    public static FacesMessage getConversionErrorMessage(UIComponent component) {
        String title = ConverterHelper.getTitle(component);
        return ConverterHelper.getConversionErrorMessage(title);
    }

    Object getComponentValue(UIComponent component) {
        ViewModelImpl viewModel = ConverterHelper.getCurrentViewModel();
        DialogObjectConstant field = ConverterHelper.getDialogObjectConstant(component);
        return viewModel.getField(field);
    }

    public static DialogObjectConstant getDialogObjectConstant(UIComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Component may not be null");
        }
        ViewModelImpl viewModel = ConverterHelper.getCurrentViewModel();
        return viewModel.getFieldDialogObjectConstant(ConverterHelper.getInternalName(component));
    }

    private static ViewModelImpl getCurrentViewModel() {
        FacesApplicationView appView = ConverterHelper.getApplicationView();
        DialogInstance currentDialog = appView.getCurrentDialog(false);
        ViewModelImpl viewModel = (ViewModelImpl)appView.getViewModel(currentDialog);
        return viewModel;
    }

    private static FacesDialogView getCurrentDialogView() {
        FacesApplicationView appView = ConverterHelper.getApplicationView();
        DialogInstance currentDialog = appView.getCurrentDialog(false);
        return (FacesDialogView)appView.getDialogView(currentDialog);
    }

    private static FacesApplicationView getApplicationView() {
        return FacesApplicationBean.getCurrentApplicationBean().getApplicationView();
    }

    private static String getTitle(UIComponent component) {
        FacesDialogView dialogView = ConverterHelper.getCurrentDialogView();
        DialogObjectConstant field = ConverterHelper.getDialogObjectConstant(component);
        if (field != null && dialogView != null) {
            return dialogView.getTitle(field);
        }
        return ConverterHelper.getInternalName(component);
    }

    private static String getInternalName(UIComponent component) {
        return component.getId();
    }
}

