/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import no.esito.log.Logger;
import no.esito.util.DateUtil;
import no.g9.client.core.view.faces.ConverterHelper;
import no.g9.client.core.view.faces.G9Converter;
import no.g9.support.FormatHelper;

public class DateConverter
extends DateTimeConverter
implements G9Converter {
    private ConverterHelper converterHelper = new ConverterHelper();
    private static final Logger log = Logger.getLogger(DateConverter.class);

    public DateConverter() {
        this.converterHelper.setDataType("date");
        this.converterHelper.setDisplayRule("");
        this.setTimeZone(TimeZone.getDefault());
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Parsing value \"" + value + "\", display rule \"" + this.getDisplayRule() + "\", data type \"" + this.getDataType() + "\""));
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        Locale locale = this.getLocale(context);
        DateFormat parser = null;
        try {
            if (this.getDataType().equals("date") || this.getDataType().equals("timestamp")) {
                parser = this.parseLocaleFormat(value);
                if (parser == null && (parser = DateUtil.getParseFormat((String)value, (Locale)locale)) == null) {
                    parser = this.getDateFormat(context, locale);
                }
                if (parser == null) {
                    throw new ParseException("", 0);
                }
            } else {
                parser = this.getDateFormat(context, locale);
            }
            if (null != this.getTimeZone()) {
                parser.setTimeZone(this.getTimeZone());
            }
            return parser.parse(value);
        }
        catch (Exception e) {
            throw new ConverterException(this.converterHelper.getConversionErrorMessage());
        }
    }

    private DateFormat parseLocaleFormat(String value) {
        DateFormat localeDateFormat = DateFormat.getDateInstance(2, this.getLocale());
        localeDateFormat.setLenient(false);
        try {
            localeDateFormat.parse(value);
        }
        catch (ParseException e) {
            localeDateFormat = null;
        }
        return localeDateFormat;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        Locale locale = this.getLocale(context);
        return this.dateToString(context, value, locale, component);
    }

    String dateToString(FacesContext context, Object value, Locale locale, UIComponent component) {
        DateFormat formatter = this.getDateFormat(context, locale);
        if (null != this.getTimeZone()) {
            formatter.setTimeZone(this.getTimeZone());
        }
        return formatter.format(value);
    }

    DateFormat getDateFormat(FacesContext context, Locale locale) {
        if (this.getDisplayRule() == null && this.getDataType() == null) {
            throw new IllegalArgumentException("Either displayRule or datatype must be specified.");
        }
        DateFormat df = null;
        if (this.getDisplayRule() != null && !this.getDisplayRule().equals("")) {
            String format = FormatHelper.getDatetimeFormat((String)this.getDisplayRule());
            if (format == null) {
                throw new IllegalArgumentException("Unsupported display rule \"" + this.getDisplayRule() + "\"");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Using format \"" + format + "\" for display rule \"" + this.getDisplayRule() + "\""));
            }
            df = new SimpleDateFormat(format, locale);
        } else if (this.getDataType().equals("both") || this.getDataType().equals("timestamp")) {
            df = DateFormat.getDateTimeInstance(this.getStyle(this.getDateStyle()), this.getStyle(this.getTimeStyle()), locale);
        } else if (this.getDataType().equals("date")) {
            df = DateFormat.getDateInstance(this.getStyle(this.getDateStyle()), locale);
        } else if (this.getDataType().equals("time")) {
            df = DateFormat.getTimeInstance(this.getStyle(this.getTimeStyle()), locale);
        } else {
            throw new IllegalArgumentException("Invalid datatype: " + this.getDataType());
        }
        df.setLenient(false);
        return df;
    }

    private Locale getLocale(FacesContext context) {
        Locale locale = super.getLocale();
        if (locale == null) {
            locale = context.getViewRoot().getLocale();
        }
        return locale;
    }

    private int getStyle(String name) {
        if (name.equals("default")) {
            return 2;
        }
        if (name.equals("short")) {
            return 3;
        }
        if (name.equals("medium")) {
            return 2;
        }
        if (name.equals("long")) {
            return 1;
        }
        if (name.equals("full")) {
            return 0;
        }
        throw new ConverterException("Invalid style '" + name + "'");
    }

    @Override
    public void setDisplayRule(String displayRule) {
        this.clearInitialState();
        this.converterHelper.setDisplayRule(displayRule);
        this.setPattern(FormatHelper.getDatetimeFormat((String)displayRule));
    }

    @Override
    public void setDataType(String dataType) {
        this.clearInitialState();
        this.converterHelper.setDataType(dataType);
    }

    @Override
    public String getDataType() {
        return this.converterHelper.getDataType();
    }

    @Override
    public String getDisplayRule() {
        return this.converterHelper.getDisplayRule();
    }

    @Override
    public void setTitle(String title) {
        this.clearInitialState();
        this.converterHelper.setTitle(title);
    }

    @Override
    public String getTitle() {
        return this.converterHelper.getTitle();
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.converterHelper, super.saveState(context)};
            return values;
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            Object[] values = (Object[])state;
            this.converterHelper = (ConverterHelper)values[0];
            super.restoreState(context, values[1]);
        }
    }
}

