/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.MethodExpressionActionListener;
import no.esito.jvine.action.GuiTask;
import no.esito.jvine.view.AbstractApplicationView;
import no.esito.jvine.view.faces.ApplicationInfo;
import no.esito.jvine.view.faces.FacesMessageUtil;
import no.esito.jvine.view.faces.MenuHelper;
import no.g9.client.core.communication.SystemMessage;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogInstance;
import no.g9.client.core.view.faces.FacesApplicationBean;
import no.g9.client.core.view.faces.FacesDialogView;
import no.g9.client.core.view.faces.FacesMenuItem;
import no.g9.client.core.view.faces.FacesSubmenu;
import no.g9.client.core.view.menu.Menu;
import no.g9.client.core.view.menu.MenuBase;
import no.g9.client.core.view.menu.MenuItem;
import no.g9.client.core.view.menu.Separator;
import no.g9.exception.G9BaseException;
import no.g9.message.MessageReplyType;
import org.icefaces.ace.component.menuseparator.MenuSeparator;
import org.icefaces.ace.component.submenu.Submenu;
import org.icefaces.ace.model.DefaultMenuModel;
import org.icefaces.ace.model.MenuModel;
import org.icefaces.util.JavaScriptRunner;

public abstract class FacesApplicationView
extends AbstractApplicationView {
    private FacesApplicationBean applicationBean;
    private List<Menu> applicationMenu = new ArrayList<Menu>();
    public static final String NOT_AVAILABLE_PREFIX = "Not available";

    public FacesApplicationView(ApplicationController applicationController) {
        super(applicationController);
    }

    public FacesApplicationBean getApplicationBean() {
        return this.applicationBean;
    }

    protected void setApplicationBean(FacesApplicationBean applicationBean) {
        this.applicationBean = applicationBean;
    }

    private String getDialogInternalName(DialogInstance instance) {
        return instance.getDialogConstant().getInternalName() + instance.getDialogInstanceNumber();
    }

    public void addMenu(Menu menu) {
        this.applicationMenu.add(menu);
    }

    public void addMenus(List<Menu> menus) {
        for (Menu menu : menus) {
            this.addMenu(menu);
        }
    }

    public MenuModel getApplicationMenuModel() {
        DefaultMenuModel appMenu = new DefaultMenuModel();
        List<Menu> dialogMenu = this.getCurrentDialogMenu();
        ArrayList<Menu> dialogMergeMenu = new ArrayList<Menu>();
        for (Menu menu : this.applicationMenu) {
            for (Menu diaMenu : dialogMenu) {
                if (!this.equalsMenu(menu, diaMenu)) continue;
                dialogMergeMenu.add(diaMenu);
            }
            dialogMenu.removeAll(dialogMergeMenu);
        }
        Menu.MENU_TYPE insertPoint = MenuHelper.getInsertPoint(this.applicationMenu);
        for (Menu menu : this.applicationMenu) {
            if (menu.getType().equals((Object)insertPoint)) {
                this.addDialogMenu((MenuModel)appMenu, dialogMenu);
            }
            FacesSubmenu submenu = this.mergeDialogMenu(menu, dialogMergeMenu);
            if (menu.getType() == Menu.MENU_TYPE.WINDOWMENU) {
                this.addWindowMenuDialogs(submenu);
            }
            appMenu.addSubmenu((UIComponent)submenu);
        }
        if (insertPoint == null) {
            this.addDialogMenu((MenuModel)appMenu, dialogMenu);
        }
        return appMenu;
    }

    public List<Submenu> getApplicationMenu() {
        MenuModel model = this.getApplicationMenuModel();
        ArrayList<Submenu> menus = new ArrayList<Submenu>();
        for (UIComponent uiComp : model.getSubmenus()) {
            menus.add((Submenu)uiComp);
        }
        return menus;
    }

    private FacesSubmenu mergeDialogMenu(Menu menu, List<Menu> dialogMenu) {
        FacesSubmenu submenu = this.asFacesSubmenu(menu);
        Iterator<Menu> it = dialogMenu.iterator();
        while (it.hasNext()) {
            Menu diaMenu = it.next();
            if (!this.equalsMenu(menu, diaMenu)) continue;
            submenu.getChildren().addAll(this.asFacesSubmenu(diaMenu).getChildren());
            it.remove();
        }
        return submenu;
    }

    private void addDialogMenu(MenuModel appMenu, List<Menu> dialogMenu) {
        for (Menu menu : dialogMenu) {
            FacesSubmenu submenu = this.asFacesSubmenu(menu);
            appMenu.addSubmenu((UIComponent)submenu);
        }
    }

    private boolean equalsMenu(Menu a, Menu b) {
        return a.getType().equals((Object)b.getType()) && (a.getType() != Menu.MENU_TYPE.USERMENU || a.getId().equals(b.getId()));
    }

    private List<Menu> getCurrentDialogMenu() {
        ArrayList<Menu> dialogMenu = new ArrayList<Menu>();
        FacesDialogView view = (FacesDialogView)this.getDialogView(this.getCurrentDialog(false));
        if (view != null) {
            dialogMenu.addAll(view.getDialogMenu());
        }
        return dialogMenu;
    }

    private void addWindowMenuDialogs(FacesSubmenu windowMenu) {
        ArrayList<FacesMenuItem> dialogs = new ArrayList<FacesMenuItem>();
        for (DialogInstance instance : this.getOpenDialogs()) {
            dialogs.add(0, this.createWindowMenuItem(this.getDialogInternalName(instance), this.getDialogTitle(instance), windowMenu.getStyleClass()));
        }
        if (!dialogs.isEmpty()) {
            if (windowMenu.getChildCount() > 0) {
                windowMenu.getChildren().add(new FacesMenuItem());
            }
            windowMenu.getChildren().addAll(dialogs);
        }
    }

    private FacesMenuItem createWindowMenuItem(String id, String title, String styleClass) {
        FacesMenuItem menuItem = new FacesMenuItem();
        menuItem.setId(id);
        menuItem.setValue(title);
        menuItem.setStyleClass(styleClass);
        menuItem.addActionListener(new ActionListener(){

            public void processAction(ActionEvent e) throws AbortProcessingException {
                String compId = null;
                if (e.getSource() instanceof UIComponent) {
                    compId = ((UIComponent)e.getSource()).getId();
                }
                DialogInstance foundInstance = null;
                for (DialogInstance instance : FacesApplicationView.this.getOpenDialogs()) {
                    if (!FacesApplicationView.this.getDialogInternalName(instance).equals(compId)) continue;
                    foundInstance = instance;
                }
                if (foundInstance != null) {
                    FacesApplicationView.this.show(foundInstance);
                }
            }
        });
        MenuHelper.addAjaxBehaviorTo(menuItem);
        return menuItem;
    }

    public FacesMenuItem asFacesMenuItem(MenuItem item) {
        FacesDialogView view = MenuHelper.getDialogView((MenuBase)item, this);
        FacesMenuItem facesItem = new FacesMenuItem();
        if (view != null) {
            facesItem.setId(item.getId());
            MenuHelper.addActionListeners(facesItem, item, view);
            MenuHelper.addAjaxBehaviorTo(facesItem);
            facesItem.setDisabled(!view.isEnabled(view.getDialogObjectFromName(item.getId())));
            facesItem.setIcon(MenuHelper.getMenuIconClass((MenuBase)item, view));
        } else {
            facesItem.setId(item.getDialogId() + "_" + item.getId());
            SystemMessage menuMessage = MenuHelper.getExternalMessage(item);
            if (menuMessage != null) {
                facesItem.setMessage(menuMessage.code());
                facesItem.setOnclick("send('" + facesItem.getMessage() + "')");
            }
        }
        facesItem.setValue(item.getTitle());
        facesItem.setMnemonic(item.getMnemonic());
        facesItem.setAccelerator(item.getAccelerator());
        facesItem.setStyleClass(MenuHelper.getStyleClass((MenuBase)item));
        return facesItem;
    }

    public MenuSeparator asFacesMenuSeparator(Separator separator) {
        MenuSeparator facesSeparator = new MenuSeparator();
        facesSeparator.setId(separator.getDialogId() + "_" + separator.getId());
        return facesSeparator;
    }

    public FacesSubmenu asFacesSubmenu(Menu menu) {
        FacesDialogView view = MenuHelper.getDialogView((MenuBase)menu, this);
        FacesSubmenu facesMenu = new FacesSubmenu();
        if (view != null) {
            facesMenu.setId(menu.getId());
            facesMenu.setDisabled(!view.isEnabled(view.getDialogObjectFromName(menu.getId())));
            facesMenu.setRendered(view.isShown(view.getDialogObjectFromName(menu.getId())));
            facesMenu.setIcon(MenuHelper.getMenuIconClass((MenuBase)menu, view));
        } else {
            facesMenu.setId(menu.getDialogId() + "_" + menu.getId());
        }
        facesMenu.setLabel(menu.getTitle());
        facesMenu.setMnemonic(menu.getMnemonic());
        facesMenu.setAccelerator(menu.getAccelerator());
        facesMenu.setStyleClass(MenuHelper.getStyleClass((MenuBase)menu));
        for (MenuBase menuBase : menu.getChildren()) {
            Object facesComp = null;
            facesComp = menuBase instanceof MenuItem ? this.asFacesMenuItem((MenuItem)menuBase) : (menuBase instanceof Separator ? this.asFacesMenuSeparator((Separator)menuBase) : this.asFacesSubmenu((Menu)menuBase));
            facesMenu.getChildren().add(facesComp);
            facesComp.setParent((UIComponent)facesMenu);
            if (view == null) continue;
            facesComp.setRendered(view.isShown(view.getDialogObjectFromName(menuBase.getId())));
        }
        return facesMenu;
    }

    public void handleMessageReply(MessageReplyType reply) {
        this.getMessage().setReplString(this.getApplicationBean().getMessageInput());
        super.handleMessageReply(reply);
        for (SystemMessage outputMessage : this.getOutputMessages()) {
            this.forward(outputMessage);
        }
    }

    public String getFacesMessage(String bundleName, String key) {
        return FacesMessageUtil.getBundleMessage(bundleName, key);
    }

    public ActionListener createActionListener(String actionExpression) {
        MethodExpressionActionListener listener = null;
        if (actionExpression != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            MethodExpression methodExpression = context.getApplication().getExpressionFactory().createMethodExpression(context.getELContext(), actionExpression, null, new Class[]{ActionEvent.class});
            listener = new MethodExpressionActionListener(methodExpression);
        }
        return listener;
    }

    public void openResource(final String resourceId, final boolean purge) {
        this.guiInvoke(new GuiTask("openResource"){

            public void run() {
                JavaScriptRunner.runScript((FacesContext)FacesContext.getCurrentInstance(), (String)("window.open('gva-resource?id=" + resourceId + "&purge=" + purge + "', 'myWindow');"));
            }
        });
    }

    public void forward(final SystemMessage message) {
        this.guiInvoke(new GuiTask("forward"){

            public void run() {
                JavaScriptRunner.runScript((FacesContext)FacesContext.getCurrentInstance(), (String)("send('" + message.code() + "');"));
            }
        });
    }

    public static List<Menu> getAllStaticApplicationMenus(String setupUrl, DialogConstant dialog) {
        ArrayList<Menu> allMenus = new ArrayList<Menu>();
        Map<String, ApplicationInfo> applicationUrls = MenuHelper.getApplications(setupUrl);
        for (String applicationName : applicationUrls.keySet()) {
            try {
                ApplicationInfo info = applicationUrls.get(applicationName);
                if (info.title.startsWith(NOT_AVAILABLE_PREFIX)) {
                    allMenus.add(MenuHelper.createApplicationMenu(applicationName, info.title, dialog));
                    continue;
                }
                List<Menu> menus = MenuHelper.getApplicationMenus(info);
                if (menus == null || menus.isEmpty()) continue;
                Menu appMenu = MenuHelper.createApplicationMenu(applicationName, info.title, dialog);
                for (Menu menu : menus) {
                    appMenu.addMenu(menu);
                }
                allMenus.add(appMenu);
            }
            catch (G9BaseException e) {
                log.info((Object)e.getMessage(), (Throwable)e);
            }
        }
        return allMenus;
    }
}

