/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import no.esito.jvine.action.ThreadManager;
import no.esito.jvine.view.AbstractApplicationView;
import no.esito.log.Logger;
import no.esito.util.BeanID;
import no.g9.client.core.message.BlockingMessageCallback;
import no.g9.client.core.message.InteractionThreadPolicy;
import no.g9.client.core.message.JVineDispatcherContext;
import no.g9.client.core.message.MessageCallback;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageInteractor;
import no.g9.message.MessageReply;
import no.g9.message.MessageTypeEnum;

@BeanID(value="messageInteractor")
public class FacesInteractor
implements MessageInteractor {
    private static final Logger log = Logger.getLogger(FacesInteractor.class);

    private InteractionThreadPolicy getPolicy(DispatcherContext dispatcherContext) {
        if (dispatcherContext instanceof JVineDispatcherContext) {
            JVineDispatcherContext jContext = (JVineDispatcherContext)dispatcherContext;
            return jContext.getInteractionThreadPolicy();
        }
        return InteractionThreadPolicy.DEFAULT_POLICY;
    }

    public MessageReply interact(Message message, DispatcherContext dispatcherContext) {
        if (message.getMsgType() == MessageTypeEnum.INLINE) {
            return null;
        }
        if (!this.policyCheck(this.getPolicy(dispatcherContext))) {
            this.throwThreadPolicyException(dispatcherContext);
        }
        log.info((Object)("Interacting message: [" + message + "], context: [" + dispatcherContext + "]"));
        if (!(dispatcherContext instanceof JVineDispatcherContext)) {
            String msg = "Expected JVineMessageContext but got " + (dispatcherContext != null ? dispatcherContext.getClass() : dispatcherContext);
            throw new IllegalArgumentException(msg);
        }
        JVineDispatcherContext jMsgContext = (JVineDispatcherContext)dispatcherContext;
        AbstractApplicationView appView = (AbstractApplicationView)jMsgContext.getApplicationView();
        appView.setMessage(message);
        MessageCallback msgCallback = jMsgContext.getMessageCallback();
        appView.setMessageCallback(msgCallback);
        Message answer = null;
        if (msgCallback instanceof BlockingMessageCallback) {
            appView.sendPushMessage();
            answer = ((BlockingMessageCallback)msgCallback).getMessage();
            appView.sendPopMessage();
        }
        log.debug((Object)("Got answer " + answer));
        return answer != null ? answer.getReply() : null;
    }

    private void throwThreadPolicyException(DispatcherContext dispatcherContext) {
        InteractionThreadPolicy policy = this.getPolicy(dispatcherContext);
        String exMsg = "Interaction on wrong thread. Current Thread is : " + Thread.currentThread().getName() + ". Thread policy is: " + policy + ", " + policy.getPolicyDescription();
        throw new IllegalStateException(exMsg);
    }

    private boolean policyCheck(InteractionThreadPolicy policy) {
        boolean currentIsWorker = ThreadManager.isWorkerThread();
        switch (policy) {
            case ASYNC_GUI_POLICY: {
                return !currentIsWorker;
            }
            case ASYNC_WORKER_POLICY: {
                return currentIsWorker;
            }
            case DEFAULT_POLICY: {
                return true;
            }
        }
        return true;
    }
}

