/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import no.esito.jvine.view.ViewModelImpl;
import no.esito.log.Logger;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.Property;
import no.g9.client.core.view.PropertyManager;
import no.g9.client.core.view.faces.FacesDialogBean;

public final class FacesPropertyMap<T>
implements Map<Object, T> {
    private static final Logger log = Logger.getLogger(FacesPropertyMap.class);
    private FacesDialogBean jsfBean;
    private Property<T> propertyType;
    private Map<String, DialogObjectConstant> enumMap = new HashMap<String, DialogObjectConstant>();

    FacesPropertyMap(Class<Enum<?>> enumType, FacesDialogBean jsfBean, Property<T> propertyType) {
        Enum<?>[] enumConstants;
        this.jsfBean = jsfBean;
        this.propertyType = propertyType;
        for (Enum<?> enum1 : enumConstants = enumType.getEnumConstants()) {
            if (!(enum1 instanceof DialogObjectConstant)) continue;
            DialogObjectConstant tmp = (DialogObjectConstant)enum1;
            this.enumMap.put(tmp.getInternalName(), tmp);
        }
    }

    private PropertyManager getPropertyManager() {
        ViewModelImpl viewModel = (ViewModelImpl)this.jsfBean.getDialogView().getViewModel();
        return viewModel.getPropertyManager();
    }

    @Override
    public T get(Object key) {
        String internalName = (String)key;
        Object prop = this.getPropertyManager().getProperty(this.enumMap.get(internalName), this.propertyType);
        log.trace((Object)("Get faces property " + this.propertyType + " for " + key + ": " + prop));
        return (T)prop;
    }

    @Override
    public T put(Object key, T value) {
        T oldValue = this.get(key);
        String internalName = (String)key;
        this.getPropertyManager().setProperty(this.enumMap.get(internalName), this.propertyType, value);
        log.trace((Object)("Set faces property " + this.propertyType + " for " + key + " to: " + value));
        return oldValue;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Object, T>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException();
    }
}

