/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import no.esito.log.Logger;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.util.MessageTextHelper;
import no.g9.client.core.view.DialogView;

public final class FacesTitleMap
implements Map<Object, String> {
    private static final Logger log = Logger.getLogger(FacesTitleMap.class);
    private Map<String, String> titleMap = new HashMap<String, String>();
    private Map<String, DialogObjectConstant> enumMap = new HashMap<String, DialogObjectConstant>();

    public FacesTitleMap(Class<Enum<?>> enumType, DialogView dialogView) {
        Enum<?>[] enumConstants;
        for (Enum<?> enum1 : enumConstants = enumType.getEnumConstants()) {
            if (!(enum1 instanceof DialogObjectConstant)) continue;
            DialogObjectConstant tmp = (DialogObjectConstant)enum1;
            this.enumMap.put(tmp.getInternalName(), tmp);
            String title = MessageTextHelper.getLabelTextForField((DialogView)dialogView, (DialogObjectConstant)tmp).toString();
            this.titleMap.put(tmp.getInternalName(), title);
        }
    }

    @Override
    public String get(Object key) {
        String internalName = (String)key;
        String title = this.titleMap.get(internalName);
        log.trace((Object)("Get faces title for " + key + ": " + title));
        return title;
    }

    @Override
    public String put(Object key, String value) {
        String oldVal = this.get(key);
        String internalName = (String)key;
        this.titleMap.put(internalName, value);
        return oldVal;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Object> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Object, String>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends String> m) {
        throw new UnsupportedOperationException();
    }
}

