/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.faces.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Observer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import no.g9.client.core.view.faces.tree.FacesTreeNode;
import no.g9.client.core.view.faces.tree.NodeObservable;

public class FacesNodeList<E extends FacesTreeNode>
extends ArrayList<E> {
    private NodeObservable obs = new NodeObservable();
    private Observer observer;

    public void addObserver(Observer obs) {
        this.obs.addObserver(obs);
        this.observer = obs;
    }

    public void deleteObservers() {
        this.obs.deleteObservers();
        this.observer = null;
    }

    private void markElementsForObservation(Collection<? extends E> c) {
        for (FacesTreeNode e : c) {
            this.markElementForObservation(e);
        }
    }

    private void markElementForObservation(E e) {
        if (this.observer != null) {
            ((FacesTreeNode)e).addObserver(this.observer);
            Enumeration<TreeNode> en = ((DefaultMutableTreeNode)e).breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                ((FacesTreeNode)en.nextElement()).addObserver(this.observer);
            }
        }
    }

    @Override
    public boolean add(E e) {
        boolean retval = super.add(e);
        this.obs.notifyObservers();
        this.markElementForObservation(e);
        return retval;
    }

    @Override
    public boolean remove(Object o) {
        boolean retval = super.remove(o);
        this.obs.notifyObservers();
        return retval;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean retval = super.addAll(c);
        this.obs.notifyObservers();
        this.markElementsForObservation(c);
        return retval;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean retval = super.addAll(index, c);
        this.obs.notifyObservers();
        this.markElementsForObservation(c);
        return retval;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean retval = super.removeAll(c);
        this.obs.notifyObservers();
        return retval;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retval = super.retainAll(c);
        this.obs.notifyObservers();
        return retval;
    }

    @Override
    public void clear() {
        super.clear();
        this.obs.notifyObservers();
    }

    @Override
    public E set(int index, E element) {
        FacesTreeNode retval = (FacesTreeNode)super.set(index, element);
        this.obs.notifyObservers();
        this.markElementForObservation(element);
        return (E)retval;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.obs.notifyObservers();
        this.markElementForObservation(element);
    }

    @Override
    public E remove(int index) {
        FacesTreeNode retval = (FacesTreeNode)super.remove(index);
        this.obs.notifyObservers();
        return (E)retval;
    }
}

