
ice.onLoad(function() {
	document.domain = document.domain;
	ice.onSessionExpiry(sessionExpiryHandler);
	ice.onServerError(serverErrorHandler);
	ice.onNetworkError(networkErrorHandler);
	parent.callbackFromFrame(window.frameElement.id);
});

var lastApplicationMenuMessage = '';

function receiveMessageFromSystem(message) 
{
	var myId = window.frameElement.id;
	if(message.receiver == myId) {
		if(message.port == 'echo')
			echoToParent(message);
		else {
			if(message.port == '_application_menu') {
				lastApplicationMenuMessage = message
			}
			var messageFromParent = parent.recodeMessage(message);
			addMessage(messageFromParent);
		}
	}
}

function send(message) 
{
	parent.send(message);
	parent.log("Sent message from " + window.frameElement.id + " , message: " + message);
}

function echoToParent(message) 
{
	send(message.payload);
}

function addMessage(message) 
{
	var inputField = document.getElementById("iceform:_communicationInput").value;
	if(inputField == '') {
		var inputMessages = new Array();
	}
	else {
		var inputMessages = JSON.parse(inputField);
	}
	inputMessages.push(message);
	document.getElementById("iceform:_communicationInput").value = JSON.stringify(inputMessages);
	parent.log("Added message to inputfield in " + window.frameElement.id + ", message: " + message);
	ice.se("valueChange", document.getElementById("iceform:_communicationInput"));
	parent.log("Called ice.se() with valueChange param in iframe " + window.frameElement.id);
}

var sessionExpiryHandler = function() {
	parent.log("Session expired for application " + window.frameElement.id);
	parent.removeApplicationFromStack(window.frameElement.id);
	parent.log("Adding last sent application menu message to messageQueue: " + JSON.stringify(lastApplicationMenuMessage));
	parent.addMessageToQueue(lastApplicationMenuMessage);
	parent.log("Reloading iframe.");
	parent.applicationTable[window.frameElement.id].state = 'reloading';
	parent.displayApplicationState(parent.applicationTable[window.frameElement.id].title, parent.applicationTable[window.frameElement.id].state, parent.statusElement);
	window.location.reload();
}

var serverErrorHandler = function(statusCode, responseText, responseDOM) 
{
	parent.removeApplicationFromStack(window.frameElement.id);
	var payload = parent.lastSentMessage;
	payload['statusCode'] = statusCode;
	payload['description'] = responseText;
	var message = "./_error_handler/" + JSON.stringify(payload);
	send(message);
	parent.applicationTable[window.frameElement.id].state = 'serverError';
	parent.displayApplicationState(parent.applicationTable[window.frameElement.id].title, parent.applicationTable[window.frameElement.id].state, parent.statusElement);
	parent.log("Server error. Stack: " + JSON.stringify(parent.stack));
}

var networkErrorHandler = function(statusCode, errorDescription) 
{
	parent.removeApplicationFromStack(window.frameElement.id);
	var payload = parent.lastSentMessage;
	payload['statusCode'] = statusCode;
	payload['description'] = errorDescription;
	var message = "./_error_handler/" + JSON.stringify(payload);
	send(message);
	parent.applicationTable[window.frameElement.id].state = 'networkError';
	parent.displayApplicationState(parent.applicationTable[window.frameElement.id].title, parent.applicationTable[window.frameElement.id].state, parent.statusElement);
	parent.log("Network error. Stack: " + JSON.stringify(parent.stack));
}