/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.view.faces;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.Callable;

import no.esito.jvine.controller.JVineController;
import no.esito.jvine.view.MessageUtil;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.exception.G9BaseException;

/**
 * Wraps invokations to FacesMessageUtil in gui - thread.
 */
@SuppressWarnings({"unchecked", "rawtypes"})
public class MessageUtilImpl implements MessageUtil {

    /* (non-Javadoc)
	 * @see no.esito.jvine.view.faces.MessageUtil#getContextMessages(no.esito.jvine.controller.JVineController, no.g9.client.core.controller.DialogObjectConstant)
	 */
	@Override
	public List getContextMessages(JVineController jController,
	        final DialogObjectConstant target) {
	    Callable<List> task = new Callable<List>() {

	        @Override
	        public List call() throws Exception {
	            return FacesMessageUtil.getContextMessages(target);
	        }
	    };

	    try {
	        return jController.invokeOnGui(task);
	    } catch (InvocationTargetException e) {
	        throw new G9BaseException(e);
	    }
	}

	/* (non-Javadoc)
	 * @see no.esito.jvine.view.faces.MessageUtil#clearContextMessages(no.esito.jvine.controller.JVineController)
	 */
	@Override
	public void clearContextMessages(JVineController jController) {
	    Runnable task = new Runnable() {

	        @Override
	        public void run() {
	            FacesMessageUtil.clearContextMessages();
	        }
	    };
	    try {
	        jController.invokeOnGui(task);
	    } catch (InvocationTargetException e) {
	        throw new G9BaseException(e);
	    }
	}

	/* (non-Javadoc)
	 * @see no.esito.jvine.view.faces.MessageUtil#hasContextMessages(no.esito.jvine.controller.JVineController)
	 */
    @Override
	public boolean hasContextMessages(JVineController jController) {
        Callable<Boolean> task = new Callable<Boolean>() {

            @Override
            public Boolean call() throws Exception {
                return FacesMessageUtil.hasContextMessages();
            }

        };
        try {
            return jController.invokeOnGui(task).booleanValue();
        } catch (InvocationTargetException e) {
            throw new G9BaseException(e);
        }
    }

    /* (non-Javadoc)
	 * @see no.esito.jvine.view.faces.MessageUtil#hasContextMessages(no.esito.jvine.controller.JVineController, no.g9.client.core.controller.DialogObjectConstant)
	 */
    @Override
	public boolean hasContextMessages(JVineController jController,
            final DialogObjectConstant target) {
        Callable<Boolean> task = new Callable<Boolean>() {

            @Override
            public Boolean call() throws Exception {
                return FacesMessageUtil.hasContextMessages(target);
            }

        };
        try {
            return jController.invokeOnGui(task);
        } catch (InvocationTargetException e) {
            throw new G9BaseException(e);
        }
    }
}
