/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view.faces;

import org.icefaces.ace.component.menuitem.MenuItem;

/**
 * Extending the MenuItem class with mnemonic and accelerator support.
 */
public class FacesMenuItem extends MenuItem {

    /** The Mnemonic key for this menu (in Alt+combination) */
    private String mnemonic;

    /** The accelerator key for this menu */
    private String accelerator;

    /** The message to send from external applications to trigger the event method of this menu item */
    private String message;

    /**
     * Returns the preferred shortcut key. If both mnemonic and accelerator
     * is set, the accelerator is returned.
     *
     * @return shortcut key
     */
    public String getShortcutKey() {
        String key = "";

        if (hasAccelerator()) {
            key = getAccelerator();
        }
        else if (hasMnemonic()) {
            key = "Alt+" + getMnemonic();
        }

        return key;
    }

    /**
     * @return the mnemonic
     */
    public String getMnemonic() {
        return this.mnemonic;
    }

    /**
     * @param mnemonic the mnemonic to set
     */
    public void setMnemonic(final String mnemonic) {
        this.mnemonic = renderMnemonic(mnemonic);
    }

    /**
     * @return true if the menu item has a mnemonic, false otherwise.
     */
    public boolean hasMnemonic() {
        if (getMnemonic() != null && getMnemonic().length() > 0) {
            return true;
        }
        return false;
    }

    /**
     * @return the accelerator
     */
    public String getAccelerator() {
        return this.accelerator;
    }

    /**
     * @param accelerator the accelerator to set
     */
    public void setAccelerator(final String accelerator) {
        this.accelerator = accelerator;
    }

    /**
     * @return true if the menu item has an accelerator, false otherwise.
     */
    public boolean hasAccelerator() {
        if (getAccelerator() != null && getAccelerator().length() > 0) {
            return true;
        }
        return false;
    }

    private String renderMnemonic(String keys) {
        if (keys == null) {
            return null;
        }

        keys = keys.replaceAll("(?i)ALT", "");
        keys = keys.replaceAll("[+]", "");

        return keys.trim();
    }

    /**
     * @return the message
     */
    public String getMessage() {
        return message;
    }

    /**
     * @param message the message to set
     */
    public void setMessage(String message) {
        this.message = message;
    }

}
