/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view.faces;

import no.esito.jvine.view.ViewModelImpl;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.ListRow;
import no.g9.client.core.view.ViewModel;
import no.g9.client.core.view.table.DefaultTableModel;

import org.icefaces.ace.model.table.RowStateMap;

/**
 * A TableModel implementation which keeps the selected state of the TableModel in synch with the RowStateMap in JSF.
 * 
 * @param <T> the generated ListRow class
 */
public class FacesTableModel<T extends ListRow> extends DefaultTableModel<T> {

	/**
	 * Create a new table model for the given columns and view model.
	 *
	 * @param columns the column definition of this table model
	 * @param viewModel the view model for the dialog
	 */
	public FacesTableModel(DialogObjectConstant[] columns, ViewModel viewModel) {
		super(columns, viewModel);
	}

	@Override
	public void setSelectionModel(SelectionModel selectionModel) {
		super.setSelectionModel(selectionModel);
		FacesDialogView dialogView = getDialogView();
		if (dialogView != null) {
			RowStateMap stateMap = dialogView.getRowStateMap(getTableRole());
			if (selectionModel == SelectionModel.NO_SELECT) {
				stateMap.setAllSelectable(false);
			} else {
				stateMap.setAllSelectable(true);
			}
		}
	}

	@Override
	public void setSelected(T row, boolean selected) {
		super.setSelected(row, selected);
		updateRowStateMap();
	}

	@Override
	public void setSelected(boolean selected) {
		super.setSelected(selected);
		updateRowStateMap();
	}

    @Override
    public void clear() {
		FacesDialogView dialogView = getDialogView();
		if (dialogView != null) {
			dialogView.setRowStateMap(getTableRole(), null);
		}
    	super.clear();
    }

	private void updateRowStateMap() {
		FacesDialogView dialogView = getDialogView();
		if (dialogView != null) {
			dialogView.updateRowState(getTableRole());
		}
	}

	private FacesDialogView getDialogView() {
		ViewModelImpl vm = (ViewModelImpl) getViewModel();
		if (vm != null) {
			return vm.getDialogView();
		}
		return null;
	}

}
