/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view.faces;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import no.esito.jvine.view.AbstractApplicationView;
import no.esito.jvine.view.faces.FacesMessageUtil;
import no.esito.log.Logger;
import no.g9.client.core.message.JVineDispatcherContext;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageLogger;
import no.g9.message.MessageTypeEnum;

/**
 * A special purpose logger which adds a message to the JSF
 * FacesContext. The message can be a compound message.
 *
 * The message can be shown in a JSF page by using the built-in
 * JSF messages tag.
 */
public class InlineFacesMessageLogger implements MessageLogger {

    private final Logger logger = Logger.getLogger(InlineFacesMessageLogger.class);

    @Override
    public void log(Message message, DispatcherContext dispatcherContext) {

        if (message.getMsgType() != MessageTypeEnum.INLINE) {
            return;
        }
        if (dispatcherContext == null) {
            logger.error("Failed to communicate the message, the dispatcher context is null.");
            return;
        }
        JVineDispatcherContext dispatcher = (JVineDispatcherContext) dispatcherContext;

        try {
            AbstractApplicationView applicationView = (AbstractApplicationView) dispatcher.getApplicationView();
			applicationView.getApplicationController().invokeOnGui(new InlineRunnable(message));
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static class InlineRunnable implements Runnable {
        private final Message message;

        public InlineRunnable(Message message) {
            this.message = message;
        }

        @Override
        public void run() {
            List<Message> messages = message.getMessages();
            if (messages.isEmpty()) {
            	FacesMessageUtil.addContextMessage(message);
            }
            else {
            	for (Message m : messages) {
            		Logger.getLogger(this.getClass()).debug(m.getMessageText());
            		FacesMessageUtil.addContextMessage(m);
            	}
            }
        }
    }

}