/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape.ejb;

import java.util.List;

import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;

import no.esito.log.Logger;
import no.g9.dataaccess.Session;
import no.g9.jgrape.DataService;
import no.g9.jgrape.DataServiceImpl;
import no.g9.jgrape.Manager;
import no.g9.jgrape.OsManager;
import no.g9.jgrape.SessionManager;
import no.g9.service.JGrapeService;
import no.g9.service.enumerator.ENavigation;
import no.g9.support.ClientContext;
import no.g9.support.FindData;
import no.g9.support.ObjectSelection;

@Remote(JGrapeService.class)
@Stateless(mappedName = "JGrapeService")
@EJB(name = "jgrapeEJB", mappedName = "jgrapeEJB")
@TransactionManagement(TransactionManagementType.BEAN)
public class JGrapeBean extends SessionManager implements JGrapeService {

    private Logger logger = no.esito.log.Logger.getLogger(JGrapeBean.class);

    public JGrapeBean() {
    }

    @Override
    @TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
    public Object find(ObjectSelection objectSelection, ClientContext ctx) {
        if (logger.isTraceEnabled()) {
            logger.trace("Find ObjectSelection " + objectSelection);
        }
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = getSession(objectSelection, ctx);
        try {
            result = manager.find(objectSelection, ctx, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            getSessionFactory().closeSession(session);
        }
        manager.cleanupResultAssociations(result, ctx, session);
        return result;
    }

    @Override
    @TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
    public Object find(FindData findData, ClientContext ctx, String dbMapping) {
        if (logger.isTraceEnabled()) {
            logger.trace("Find FindData " + findData);
        }
        Object result = null;
        Session session = getSession(ctx, dbMapping);
        try {
            DataService dataService = new DataServiceImpl();
            result = dataService.find(findData, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            getSessionFactory().closeSession(session);
        }
        return result;
    }

    @Override
    @TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
    public List<?> findAll(ObjectSelection objectSelection, ClientContext ctx) {
        if (logger.isTraceEnabled()) {
            logger.trace("FindAll ObjectSelection " + objectSelection);
        }
        List<?> result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = getSession(objectSelection, ctx);
        try {
            result = manager.findAll(objectSelection, ctx, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            getSessionFactory().closeSession(session);
        }
        manager.cleanupResultAssociations(result, ctx, session);
        return result;
    }

    @Override
    @TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
    public List<?> findAll(FindData findData, ClientContext ctx, String dbMapping) {
        if (logger.isTraceEnabled()) {
            logger.trace("FindAll FindData " + findData);
        }
        List<?> result = null;
        Session session = getSession(ctx, dbMapping);
        try {
            DataService dataService = new DataServiceImpl();
            result = dataService.findAll(findData, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            getSessionFactory().closeSession(session);
        }
        return result;
    }

    @Override
    @TransactionAttribute(value = TransactionAttributeType.REQUIRED)
    public Object save(ObjectSelection objectSelection, ClientContext ctx) {
        if (logger.isTraceEnabled()) {
            logger.trace("Save ObjectSelection " + objectSelection);
        }
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = getSession(objectSelection, ctx);
        try {
            session.beginTransaction();
            result = manager.save(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    @Override
    @TransactionAttribute(value = TransactionAttributeType.REQUIRED)
    public Object insert(ObjectSelection objectSelection, ClientContext ctx) {
        if (logger.isTraceEnabled()) {
            logger.trace("Insert ObjectSelection " + objectSelection);
        }
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = getSession(objectSelection, ctx);
        try {
            session.beginTransaction();
            result = manager.insert(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    @Override
    @TransactionAttribute(value = TransactionAttributeType.REQUIRED)
    public Object update(ObjectSelection objectSelection, ClientContext ctx) {
        if (logger.isTraceEnabled()) {
            logger.trace("Update ObjectSelection " + objectSelection);
        }
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = getSession(objectSelection, ctx);
        try {
            session.beginTransaction();
            result = manager.update(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    @Override
    @TransactionAttribute(value = TransactionAttributeType.REQUIRED)
    public Object delete(ObjectSelection objectSelection, ClientContext ctx) {
        if (logger.isTraceEnabled()) {
            logger.trace("Delete ObjectSelection " + objectSelection);
        }
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = getSession(objectSelection, ctx);
        try {
            session.beginTransaction();
            result = manager.delete(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    @Override
    @TransactionAttribute(value = TransactionAttributeType.REQUIRED)
    public Object connect(ObjectSelection objectSelection, ClientContext ctx) {
        if (logger.isTraceEnabled()) {
            logger.trace("Connect ObjectSelection " + objectSelection);
        }
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = getSession(objectSelection, ctx);
        try {
            session.beginTransaction();
            result = manager.insert(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    @Override
    @TransactionAttribute(value = TransactionAttributeType.REQUIRED)
    public Object disconnect(ObjectSelection objectSelection, ClientContext ctx) {
        if (logger.isTraceEnabled()) {
            logger.trace("Disconnect ObjectSelection " + objectSelection);
        }
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = getSession(objectSelection, ctx);
        try {
            session.beginTransaction();
            result = manager.disconnect(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    @Override
    @TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
    public Object get(ObjectSelection objectSelection, ENavigation navigation, ClientContext ctx) {
        Object result = null;
        Session session = getSession(objectSelection, ctx);
        try {
// NotImpl'd           result = getManager(objectSelection).get(objectSelection, navigation, ctx, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            getSessionFactory().closeSession(session);
        }
        return result;
    }
}
