/*
 * Decompiled with CFR 0.152.
 */
package no.g9.jgrape.ejb;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import no.esito.log.Logger;
import no.g9.dataaccess.Session;
import no.g9.jgrape.DataServiceImpl;
import no.g9.jgrape.Manager;
import no.g9.jgrape.OsManager;
import no.g9.jgrape.SessionManager;
import no.g9.service.JGrapeService;
import no.g9.service.enumerator.ENavigation;
import no.g9.support.ClientContext;
import no.g9.support.FindData;
import no.g9.support.ObjectSelection;

@Remote(value={JGrapeService.class})
@Stateless(mappedName="JGrapeService")
@EJB(name="jgrapeEJB", mappedName="jgrapeEJB")
@TransactionManagement(value=TransactionManagementType.BEAN)
public class JGrapeBean
extends SessionManager
implements JGrapeService {
    private Logger logger = Logger.getLogger(JGrapeBean.class);

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public Object find(ObjectSelection objectSelection, ClientContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Find ObjectSelection " + objectSelection));
        }
        Object result = null;
        Manager manager = OsManager.getManager((ObjectSelection)objectSelection);
        Session session = JGrapeBean.getSession((ObjectSelection)objectSelection, (ClientContext)ctx);
        try {
            result = manager.find(objectSelection, ctx, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JGrapeBean.getSessionFactory().closeSession(session);
        }
        manager.cleanupResultAssociations(result, ctx, session);
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public Object find(FindData findData, ClientContext ctx, String dbMapping) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Find FindData " + findData));
        }
        Object result = null;
        Session session = JGrapeBean.getSession((ClientContext)ctx, (String)dbMapping);
        try {
            DataServiceImpl dataService = new DataServiceImpl();
            result = dataService.find(findData, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JGrapeBean.getSessionFactory().closeSession(session);
        }
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public List<?> findAll(ObjectSelection objectSelection, ClientContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("FindAll ObjectSelection " + objectSelection));
        }
        List result = null;
        Manager manager = OsManager.getManager((ObjectSelection)objectSelection);
        Session session = JGrapeBean.getSession((ObjectSelection)objectSelection, (ClientContext)ctx);
        try {
            result = manager.findAll(objectSelection, ctx, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JGrapeBean.getSessionFactory().closeSession(session);
        }
        manager.cleanupResultAssociations((Object)result, ctx, session);
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public List<?> findAll(FindData findData, ClientContext ctx, String dbMapping) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("FindAll FindData " + findData));
        }
        List result = null;
        Session session = JGrapeBean.getSession((ClientContext)ctx, (String)dbMapping);
        try {
            DataServiceImpl dataService = new DataServiceImpl();
            result = dataService.findAll(findData, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JGrapeBean.getSessionFactory().closeSession(session);
        }
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Object save(ObjectSelection objectSelection, ClientContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Save ObjectSelection " + objectSelection));
        }
        Object result = null;
        Manager manager = OsManager.getManager((ObjectSelection)objectSelection);
        Session session = JGrapeBean.getSession((ObjectSelection)objectSelection, (ClientContext)ctx);
        try {
            session.beginTransaction();
            result = manager.save(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            JGrapeBean.getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Object insert(ObjectSelection objectSelection, ClientContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Insert ObjectSelection " + objectSelection));
        }
        Object result = null;
        Manager manager = OsManager.getManager((ObjectSelection)objectSelection);
        Session session = JGrapeBean.getSession((ObjectSelection)objectSelection, (ClientContext)ctx);
        try {
            session.beginTransaction();
            result = manager.insert(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            JGrapeBean.getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Object update(ObjectSelection objectSelection, ClientContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Update ObjectSelection " + objectSelection));
        }
        Object result = null;
        Manager manager = OsManager.getManager((ObjectSelection)objectSelection);
        Session session = JGrapeBean.getSession((ObjectSelection)objectSelection, (ClientContext)ctx);
        try {
            session.beginTransaction();
            result = manager.update(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            JGrapeBean.getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Object delete(ObjectSelection objectSelection, ClientContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Delete ObjectSelection " + objectSelection));
        }
        Object result = null;
        Manager manager = OsManager.getManager((ObjectSelection)objectSelection);
        Session session = JGrapeBean.getSession((ObjectSelection)objectSelection, (ClientContext)ctx);
        try {
            session.beginTransaction();
            result = manager.delete(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            JGrapeBean.getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Object connect(ObjectSelection objectSelection, ClientContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Connect ObjectSelection " + objectSelection));
        }
        Object result = null;
        Manager manager = OsManager.getManager((ObjectSelection)objectSelection);
        Session session = JGrapeBean.getSession((ObjectSelection)objectSelection, (ClientContext)ctx);
        try {
            session.beginTransaction();
            result = manager.insert(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            JGrapeBean.getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Object disconnect(ObjectSelection objectSelection, ClientContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Disconnect ObjectSelection " + objectSelection));
        }
        Object result = null;
        Manager manager = OsManager.getManager((ObjectSelection)objectSelection);
        Session session = JGrapeBean.getSession((ObjectSelection)objectSelection, (ClientContext)ctx);
        try {
            session.beginTransaction();
            result = manager.disconnect(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            JGrapeBean.getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public Object get(ObjectSelection objectSelection, ENavigation navigation, ClientContext ctx) {
        Object result = null;
        Session session = JGrapeBean.getSession((ObjectSelection)objectSelection, (ClientContext)ctx);
        JGrapeBean.getSessionFactory().closeSession(session);
        return result;
    }
}

