/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape.trigger;

import java.util.List;

/**
 * The trigger register provides a list of triggers for a Class.
 */
public interface TriggerRegistry {

    /**
     * Get the list of registered JGrapeTriggers for the specified class.
     * 
     * @param clazz the class to get triggers for.
     * @return a list of triggers or <code>null</code> if no triggers are
     *         registered on this TriggerRegistry.
     */
    List<JGrapeTrigger<?>> getRegistredTriggers(Class<?> clazz);

}
