/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape.tx;

import java.io.Serializable;

import no.g9.dataaccess.Session;
import no.g9.support.ClientContext;

/**
 * Interface for callback methods to be executed within a separate transaction.
 * <p>
 * An instance implementing this interface may be executed within a transaction
 * context different from its caller by calling
 * {@link TxService#executeCommand(ClientContext, String, TxCommand)}.
 * </p>
 */
public interface TxCommand extends Serializable{

    /**
     * This method is called in a separate transaction context, that is
     * automatically committed, unless a RuntimeException is thrown.
     *
     * @param clientContext Current client context
     * @param session A session within a new transaction context
     */
    void execute(ClientContext clientContext, Session session);

}
