/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape.tx;

import no.g9.dataaccess.Session;
import no.g9.exception.G9BaseException;
import no.g9.support.ClientContext;

/**
 * 
 */
public class TxLocal extends TxSessionManager implements TxService {

    /** {@inheritDoc } */
    @Override
    public TxCommand executeCommand(final ClientContext clientContext,
                                    final String databaseMappingName,
                                    final TxCommand command) {
        final Session session = getSession(clientContext.getDatabaseContext(), 
                                           databaseMappingName);
        try {
            runTx(session, clientContext, command);            
        }       
        catch (final Exception e) {
            throw new G9BaseException(e);
        }
        finally {
            resetSession(clientContext.getDatabaseContext(), databaseMappingName);
        }
        return command;
    }

}
